package com.xebialabs.deployit.engine.tasker

import akka.actor._
import akka.actor.Status.Failure
import akka.actor.Status.Success
import grizzled.slf4j.Logging

object TaskRegistryExtension extends ExtensionId[TaskRegistryExtension] with ExtensionIdProvider {
    //The lookup method is required by ExtensionIdProvider,
    // so we return ourselves here, this allows us
    // to configure our extension to be loaded when
    // the ActorSystem starts up
    override def lookup = TaskRegistryExtension

    //This method will be called by Akka
    // to instantiate our Extension
    override def createExtension(system: ExtendedActorSystem) = new TaskRegistryExtension
}

class TaskRegistryExtension extends Extension with Logging {
  info("Booting Task Registry")
  val store: Cache[String, Task] = Cache[String, Task]()

  def getTask(id: TaskId) = store.get(id)

  def getTasks = store.values.toSeq

  def deleteTask(id: TaskId) {
    store.remove(id)
  }

  protected[tasker] def clear = store.clear()

  def register(task: Task) {
    if (store.contains(task.getId)) throw new IllegalStateException(s"Task with id [${task.getId}] is already registered")
    store.put(task.getId, task)
  }
}
