package com.xebialabs.deployit.engine.tasker;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

import org.joda.time.DateTime;

import akka.actor.ActorSystem;

public interface IEngine {
    String register(TaskSpecification spec);

    Task retrieve(String taskid);

    void execute(String taskid);

    void schedule(String taskid, DateTime scheduleAt);

    void abort(String taskid);

    void stop(String taskid);

    void cancel(String taskid);

    @Deprecated
    void skipSteps(String taskid, List<Integer> stepNrs);

    @Deprecated
    void unskipSteps(String taskid, List<Integer> stepNrs);

    void skipStepPaths(String taskid, List<BlockPath> stepNrs);

    void unskipStepPaths(String taskid, List<BlockPath> stepNrs);

    void moveStep(String taskid, int stepNr, int newPosition);

    void addPauseStep(String taskid, BlockPath position);

    @Deprecated
    void addPauseStep(String taskid, Integer position);

    List<Task> getAllIncompleteTasks();

    void archive(String taskid);

    ActorSystem getSystem();

    @PostConstruct
    void recoverTasks();

    @PreDestroy
    void shutdownTasks();
}
