/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.plugin.api.flow.Step;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStep
implements StepState,
Serializable {
    public static final String ERROR_PREFIX = "[ERROR]: ";
    private final Step implementation;
    private final Map<String, String> metadata = Maps.newHashMap();
    private volatile StepExecutionState state;
    private transient Thread runningThread;
    private AtomicInteger failureCount;
    StringBuilder logBuilder;
    private DateTime startDate;
    private DateTime completionDate;
    private DateTime lastModificationDate;
    private String description;
    static final Logger logger = LoggerFactory.getLogger(TaskStep.class);

    public TaskStep(Step step2) {
        this.implementation = step2;
        this.state = StepExecutionState.PENDING;
        this.failureCount = new AtomicInteger();
        this.logBuilder = new StringBuilder();
        this.description = step2.getDescription();
    }

    public Step getImplementation() {
        return this.implementation;
    }

    void setState(StepExecutionState state) {
        this.state = state;
        if (state == StepExecutionState.FAILED) {
            this.failureCount.incrementAndGet();
        }
        this.touch();
    }

    void recordStart() {
        this.startDate = new DateTime(DateTimeZone.UTC);
        this.touch();
    }

    void recordCompletion() {
        this.completionDate = new DateTime(DateTimeZone.UTC);
        this.touch();
    }

    void clearLog() {
        this.logBuilder.setLength(0);
    }

    void touch() {
        this.lastModificationDate = new DateTime(DateTimeZone.UTC);
    }

    public boolean isMarkedForSkip() {
        return this.getState() == StepExecutionState.SKIP;
    }

    public boolean canSkip() {
        return this.getState() == StepExecutionState.PENDING || this.getState() == StepExecutionState.FAILED || this.getState() == StepExecutionState.SKIP;
    }

    public boolean hasExecuted() {
        return this.state == StepExecutionState.DONE || this.state == StepExecutionState.SKIPPED;
    }

    public String toString() {
        return "[" + this.description + "]";
    }

    public StepExecutionState getState() {
        return this.state;
    }

    public String getLog() {
        return this.logBuilder.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getCompletionDate() {
        return this.completionDate;
    }

    public DateTime getLastModificationDate() {
        return this.lastModificationDate;
    }

    public int getFailureCount() {
        return this.failureCount.intValue();
    }

    public void setRunner() {
        this.runningThread = Thread.currentThread();
    }

    public void interruptRunner() {
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public boolean isFailed() {
        return this.getState() == StepExecutionState.FAILED;
    }

    public TaskStep recovered() {
        if (this.state == StepExecutionState.EXECUTING) {
            this.setState(StepExecutionState.FAILED);
        }
        return this;
    }
}

