package com.xebialabs.deployit.engine.tasker;

import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;

@SuppressWarnings("deprecation")
public class OldExecutionContextListenerCleanupTrigger implements ExecutionStateListener {
    private static final Set<TaskExecutionState> killStates = EnumSet.of(TaskExecutionState.EXECUTED, TaskExecutionState.STOPPED, TaskExecutionState.FAILED, TaskExecutionState.ABORTED);
    private String key;
    private ExecutionContextListener wrappedListener;

    public OldExecutionContextListenerCleanupTrigger(String key, ExecutionContextListener wrappedListener) {
        this.key = key;
        this.wrappedListener = wrappedListener;
    }

    public ExecutionContextListener getWrappedListener() {
        return wrappedListener;
    }

    @Override
    public void stepStateChanged(final StepExecutionStateEvent event) {
    }

    @Override
    public void taskStateChanged(final TaskExecutionStateEvent event) {
        if (killStates.contains(event.currentState())) {
            logger.info("Cleaning up [{}] which is an [{}]", key, wrappedListener);
            cleanupListener();
        }
    }

    private void cleanupListener() {
        try {
            wrappedListener.contextDestroyed();
        } catch (RuntimeException re) {
            logger.error("Exception while cleaning up object {} in execution context", wrappedListener);
            logger.error("Exception is: ", re);
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(OldExecutionContextListenerCleanupTrigger.class);
}
