/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.satellite;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001f\tQqJ\u00196fGR\u0004vn\u001c7\u000b\u0005\r!\u0011!C:bi\u0016dG.\u001b;f\u0015\t)a!\u0001\u0004uCN\\WM\u001d\u0006\u0003\u000f!\ta!\u001a8hS:,'BA\u0005\u000b\u0003!!W\r\u001d7ps&$(BA\u0006\r\u0003%AXMY5bY\u0006\u00147OC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001+\t\u00012e\u0005\u0002\u0001#A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001aD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I!G\u0001\u0007]Vl'-\u001a:\u0011\u0005IQ\u0012BA\u000e\u0014\u0005\rIe\u000e\u001e\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005Ya.Z<J]N$\u0018M\\2f!\r\u0011r$I\u0005\u0003AM\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\t\u001aC\u0002\u0001\u0003\u0006I\u0001\u0011\r!\n\u0002\u0002)F\u0011a%\u000b\t\u0003%\u001dJ!\u0001K\n\u0003\u000f9{G\u000f[5oOB\u0011!CK\u0005\u0003WM\u00111!\u00118z\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\u0019q&\r\u001a\u0011\u0007A\u0002\u0011%D\u0001\u0003\u0011\u0015AB\u00061\u0001\u001a\u0011\u0015iB\u00061\u0001\u001f\u0011\u001d!\u0004A1A\u0005\nU\nAa]5{KV\ta\u0007\u0005\u00028\u00016\t\u0001H\u0003\u0002:u\u00051\u0011\r^8nS\u000eT!a\u000f\u001f\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002>}\u0005!Q\u000f^5m\u0015\u0005y\u0014\u0001\u00026bm\u0006L!!\u0011\u001d\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011\u0019\u0019\u0005\u0001)A\u0005m\u0005)1/\u001b>fA!9Q\t\u0001b\u0001\n\u00131\u0015\u0001\u00029p_2,\u0012a\u0012\t\u0004\u0011&\u000bS\"\u0001\u001e\n\u0005)S$AE!se\u0006L(\t\\8dW&tw-U;fk\u0016Da\u0001\u0014\u0001!\u0002\u00139\u0015!\u00029p_2\u0004\u0003\"\u0002(\u0001\t\u0003y\u0015!\u00024fi\u000eDG#A\u0011\t\u000bE\u0003A\u0011\u0001*\u0002\u000fI,G.Z1tKR\u00111K\u0016\t\u0003%QK!!V\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006/B\u0003\r!I\u0001\u0002_\")\u0011\f\u0001C\u00015\u0006\u0019\u0011\r\u001a3\u0015\u0005M[\u0006\"B,Y\u0001\u0004\t\u0003\"B/\u0001\t\u0013q\u0016!D2sK\u0006$Xm\u0014:CY>\u001c7.F\u0001\"\u0011\u0015\u0001\u0007\u0001\"\u0003_\u0003\u0019\u0019'/Z1uK\")!\r\u0001C\u0005=\u0006)!\r\\8dW\u0002")
public class ObjectPool<T> {
    private final int number;
    private final Function0<T> newInstance;
    private final AtomicInteger size;
    private final ArrayBlockingQueue<T> pool;

    private AtomicInteger size() {
        return this.size;
    }

    private ArrayBlockingQueue<T> pool() {
        return this.pool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T fetch() {
        T t;
        T t2 = this.pool().poll();
        if (t2 == null) {
            if (t2 != null) throw new MatchError(t2);
            t = this.createOrBlock();
            return t;
        } else {
            t = t2;
        }
        return t;
    }

    public void release(T o) {
        this.pool().offer(o);
    }

    public void add(T o) {
        this.pool().add(o);
    }

    private T createOrBlock() {
        int n = this.size().get();
        int n2 = n;
        T t = n2 == this.number ? this.block() : this.create();
        return t;
    }

    private T create() {
        Object object;
        int n = this.size().incrementAndGet();
        int n2 = n;
        if (n2 > this.number) {
            this.size().decrementAndGet();
            object = this.fetch();
        } else {
            object = this.newInstance.apply();
        }
        return (T)object;
    }

    private T block() {
        int timeout = 5000;
        T t = this.pool().poll(timeout, TimeUnit.MILLISECONDS);
        if (t == null) {
            throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Couldn't acquire object in %d milliseconds.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)timeout)})));
        }
        T t2 = t;
        return t2;
    }

    public ObjectPool(int number, Function0<T> newInstance) {
        this.number = number;
        this.newInstance = newInstance;
        this.size = new AtomicInteger(0);
        this.pool = new ArrayBlockingQueue(number);
    }
}

