/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.security.core.Authentication;

public class TaskSpecification
implements Serializable {
    private final String description;
    private final Authentication owner;
    private final PhaseContainer block;
    private final Map<String, String> metadata = Maps.newHashMap();
    private List<ExecutionStateListener> listeners = Lists.newArrayList();
    private final File tempWorkDir;
    private final String id;
    private TaskInspectionContext inspectionContext;
    private boolean recoverable;
    private boolean archiveable;
    private boolean nonInteractive;

    public TaskSpecification(String description, Authentication owner, PhaseContainer block) {
        this(description, owner, block, null);
    }

    public TaskSpecification(String description, Authentication owner, PhaseContainer block, TaskInspectionContext inspectionContext) {
        this(description, owner, block, inspectionContext, true);
    }

    public TaskSpecification(String description, Authentication owner, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable) {
        this(description, owner, block, inspectionContext, null, recoverable, true);
    }

    public TaskSpecification(String description, Authentication owner, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable) {
        this(description, owner, block, inspectionContext, null, recoverable, archiveable);
    }

    public TaskSpecification(String description, Authentication owner, PhaseContainer block, TaskInspectionContext inspectionContext, File tempWorkDir, boolean recoverable, boolean archiveable) {
        this(description, owner, block, inspectionContext, tempWorkDir, recoverable, archiveable, false);
    }

    public TaskSpecification(String description, Authentication owner, PhaseContainer block, TaskInspectionContext inspectionContext, File tempWorkDir, boolean recoverable, boolean archiveable, boolean nonInteractive) {
        this(UUID.randomUUID().toString(), description, owner, block, inspectionContext, tempWorkDir, recoverable, archiveable, nonInteractive);
    }

    public TaskSpecification(String id, String description, Authentication owner, PhaseContainer block, TaskInspectionContext inspectionContext, File tempWorkDir, boolean recoverable, boolean archiveable) {
        this(id, description, owner, block, inspectionContext, tempWorkDir, recoverable, archiveable, false);
    }

    public TaskSpecification(String id, String description, Authentication owner, PhaseContainer block, TaskInspectionContext inspectionContext, File tempWorkDir, boolean recoverable, boolean archiveable, boolean nonInteractive) {
        this.id = id;
        this.description = description;
        this.owner = owner;
        this.block = block;
        this.inspectionContext = inspectionContext;
        this.tempWorkDir = tempWorkDir;
        this.recoverable = recoverable;
        this.archiveable = archiveable;
        this.nonInteractive = nonInteractive;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public List<TaskStep> getSteps() {
        return this.block.getStepList();
    }

    public PhaseContainer getBlock() {
        return this.block;
    }

    public Authentication getOwner() {
        return this.owner;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public List<ExecutionStateListener> getListeners() {
        return this.listeners;
    }

    public TaskInspectionContext getInspectionContext() {
        return this.inspectionContext;
    }

    public File getTempWorkDir() {
        return this.tempWorkDir;
    }

    public boolean isRecoverable() {
        return this.recoverable;
    }

    public boolean isArchiveable() {
        return this.archiveable;
    }

    public boolean isNonInteractive() {
        return this.nonInteractive;
    }
}

