package com.xebialabs.deployit.engine.tasker

import akka.actor.{Actor, ActorLogging, ActorRef, Props}
import com.xebialabs.deployit.engine.tasker.StateChangeEventListenerActor.{StepStateEvent, TaskStateEvent}
import com.xebialabs.deployit.engine.tasker.messages.TaskStateEventHandled

import scala.language.postfixOps

object TaskRecoveryListener {
  def props(recoverySupervisorActor: ActorRef) = Props(new TaskRecoveryListener(recoverySupervisorActor))

  val name = "task-recovery-listener"
}

class TaskRecoveryListener(recoverySupervisorActor: ActorRef) extends Actor with ActorLogging {

  import context._

  override def preStart(): Unit = {
    system.eventStream.subscribe(self, classOf[TaskStateEvent])
    system.eventStream.subscribe(self, classOf[StepStateEvent])
    super.preStart()
  }

  def receive: Actor.Receive = {
    case TaskStateEvent(_, task, _, state) if !state.isFinal =>
      recoverySupervisorActor ! RecoverySupervisorActor.Write(task)
    case TaskStateEvent(taskId, task, oldState, state) if state.isFinal =>
      recoverySupervisorActor ! RecoverySupervisorActor.Delete(taskId)
      system.eventStream.publish(TaskStateEventHandled(taskId, oldState, state))
    case StepStateEvent(_, _, task, _, _, _, _) =>
      recoverySupervisorActor ! RecoverySupervisorActor.Write(task)
  }
}
