package com.xebialabs.deployit.engine.tasker.satellite

import akka.actor._
import com.xebialabs.xlplatform.satellite.Satellite

trait SatellitePath {

  def locate(remotePath: ActorPath)(implicit actorSystem: ActorSystem): ActorSelection
}

object SatellitePath {

  def apply(satellite: Satellite): SatellitePath = new RemoteSatellitePath(satellite)

  def apply(): SatellitePath = LocalSatellite
}

private case class RemoteSatellitePath(satellite: Satellite) extends SatellitePath {

  override def locate(remotePath: ActorPath)(implicit actorSystem: ActorSystem): ActorSelection = {
    val remoteAddress = remotePath.toSerializationFormatWithAddress(address)
    actorSystem.actorSelection(remoteAddress)
  }

  private def address: Address =
    Address(protocol, Paths.systemName, satellite.getAddress, satellite.getProtocolPort)

  private def protocol: String =
    if (satellite.isEncrypted) {
      "akka.ssl.tcp"
    } else {
      "akka.tcp"
    }
}

private case object LocalSatellite extends SatellitePath {

  override def locate(remotePath: ActorPath)(implicit actorSystem: ActorSystem): ActorSelection = {
    actorSystem.actorSelection(remotePath)
  }
}
