package com.xebialabs.deployit.engine.tasker

import java.util.concurrent.TimeUnit

import akka.actor._
import akka.util.Timeout
import com.typesafe.config.{ConfigFactory, Config}
import java.io.File
import scala.concurrent.duration._

class TaskerSettings(config: Config) extends Extension {
  val recoveryDir = new File(config.getString("deployit.task.recovery-dir"))
  val tickDuration = config.getDuration("akka.scheduler.tick-duration", TimeUnit.MILLISECONDS)
  val askTimeout = Timeout((if (config.hasPath("deployit.tasker.askTimeout")) config.getDuration("deployit.tasker.askTimeout", TimeUnit.SECONDS) else 1).seconds)
}

object TaskerSettings extends ExtensionId[TaskerSettings] with ExtensionIdProvider {

  override def lookup = TaskerSettings

  override def createExtension(system: ExtendedActorSystem) =
    new TaskerSettings(ConfigFactory.load("tasker").withFallback(system.settings.config))

  /**
   * Java API: retrieve the Settings extension for the given system.
   */
  override def get(system: ActorSystem): TaskerSettings = super.get(system)
}
