/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import akka.actor.ActorSystem;
import com.xebialabs.deployit.engine.api.execution.BlockExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.CompositeBlock;
import com.xebialabs.deployit.engine.tasker.StateChangeEventListenerActor;
import com.xebialabs.deployit.engine.tasker.StepBlock;
import com.xebialabs.deployit.engine.tasker.Task$;
import com.xebialabs.deployit.engine.tasker.TaskExecutionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.step.PauseStep;
import grizzled.slf4j.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r%r!B\u0001\u0003\u0011\u0003i\u0011\u0001\u0002+bg.T!a\u0001\u0003\u0002\rQ\f7o[3s\u0015\t)a!\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u000f!\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011A\u0001V1tWN\u0019qB\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\t\u0019\u0012$\u0003\u0002\u001b)\ta1+\u001a:jC2L'0\u00192mK\")Ad\u0004C\u0001;\u00051A(\u001b8jiz\"\u0012!\u0004\u0005\b?=\u0011\r\u0011\"\u0001!\u0003\u0019awnZ4feV\t\u0011\u0005\u0005\u0002#O5\t1E\u0003\u0002%K\u0005)1\u000f\u001c45U*\ta%\u0001\u0005he&T(\u0010\\3e\u0013\tA3E\u0001\u0004M_\u001e<WM\u001d\u0005\u0007U=\u0001\u000b\u0011B\u0011\u0002\u000f1|wmZ3sA!)Af\u0004C\u0001[\u0005)\u0011\r\u001d9msR\u0019afa\b\u0011\u0007My\u0013'\u0003\u00021)\t1q\n\u001d;j_:\u0004\"A\u0004\u001a\u0007\tA\u0011\u0001aM\n\u0006eQbDi\u0012\t\u0003kij\u0011A\u000e\u0006\u0003oa\nA\u0001\\1oO*\t\u0011(\u0001\u0003kCZ\f\u0017BA\u001e7\u0005\u0019y%M[3diB\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\nKb,7-\u001e;j_:T!!\u0011\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002D}\tiA+Y:l/&$\bn\u0015;faN\u0004\"!P#\n\u0005\u0019s$!\u0004+bg.<\u0016\u000e\u001e5CY>\u001c7\u000e\u0005\u0002I\u00176\t\u0011J\u0003\u0002Kq\u0005\u0011\u0011n\\\u0005\u00035%C\u0001\"\u0014\u001a\u0003\u0002\u0003\u0006IAT\u0001\u0003S\u0012\u0004\"a\u0014*\u000f\u00059\u0001\u0016BA)\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0015+\u0003\rQ\u000b7o[%e\u0015\t\t&\u0001\u0003\u0005We\t\u0005\t\u0015!\u0003X\u0003\u0011\u0019\b/Z2\u0011\u00059A\u0016BA-\u0003\u0005E!\u0016m]6Ta\u0016\u001c\u0017NZ5dCRLwN\u001c\u0005\u00069I\"\ta\u0017\u000b\u0004cqk\u0006\"B'[\u0001\u0004q\u0005\"\u0002,[\u0001\u00049\u0006\"\u0002\u000f3\t\u0003yFcA\u0019aC\")QJ\u0018a\u0001\u001d\")!M\u0018a\u0001G\u0006)!\r\\8dWB\u0011a\u0002Z\u0005\u0003K\n\u0011QA\u00117pG.Daa\u001a\u001a!B\u0013A\u0017!C:uCJ$H)\u0019;f!\tI\u0007/D\u0001k\u0015\tYG.\u0001\u0003uS6,'BA7o\u0003\u0011Qw\u000eZ1\u000b\u0003=\f1a\u001c:h\u0013\t\t(N\u0001\u0005ECR,G+[7f\u0011\u0019\u0019(\u0007)Q\u0005Q\u0006q1m\\7qY\u0016$\u0018n\u001c8ECR,\u0007BB;3A\u0003&\u0001.A\u0007tG\",G-\u001e7fI\u0012\u000bG/\u001a\u0005\u0007oJ\u0002\u000b\u0015\u0002=\u0002\u000b=<h.\u001a:\u0011\u0005UJ\u0018B\u0001>7\u0005\u0019\u0019FO]5oO\"1AP\rQ!\nu\fABZ1jYV\u0014XmQ8v]R\u0004\"a\u0005@\n\u0005}$\"aA%oi\"A\u00111\u0001\u001a!B\u0013\t)!A\u0003ti\u0006$X\rE\u0002>\u0003\u000fI1!!\u0003?\u0005I!\u0016m]6Fq\u0016\u001cW\u000f^5p]N#\u0018\r^3\t\u0011\t\u0014\u0004\u0019!C\u0001\u0003\u001b)\u0012a\u0019\u0005\n\u0003#\u0011\u0004\u0019!C\u0001\u0003'\t\u0011B\u00197pG.|F%Z9\u0015\t\u0005U\u00111\u0004\t\u0004'\u0005]\u0011bAA\r)\t!QK\\5u\u0011%\ti\"a\u0004\u0002\u0002\u0003\u00071-A\u0002yIEBq!!\t3A\u0003&1-\u0001\u0004cY>\u001c7\u000e\t\u0005\t\u0003K\u0011\u0004\u0015\"\u0003\u0002(\u0005)1\u000f^3qgV\u0011\u0011\u0011\u0006\t\u0007\u0003W\tI$a\u0010\u000f\t\u00055\u0012q\u0007\b\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111\u0007\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012BA)\u0015\u0013\u0011\tY$!\u0010\u0003\u0015%sG-\u001a=fIN+\u0017O\u0003\u0002R)A11#!\u0011\u0002FuL1!a\u0011\u0015\u0005\u0019!V\u000f\u001d7feA91#!\u0011\u0002H\u00055\u0003c\u0001\b\u0002J%\u0019\u00111\n\u0002\u0003\u0013\tcwnY6QCRD\u0007cA\u001f\u0002P%\u0019\u0011\u0011\u000b \u0003\u0013M#X\r]*uCR,\u0007\"CA+e\t\u0007I\u0011AA,\u0003\u001d\u0019wN\u001c;fqR,\"!!\u0017\u0011\u00079\tY&C\u0002\u0002^\t\u0011A\u0003V1tW\u0016CXmY;uS>t7i\u001c8uKb$\b\u0002CA1e\u0001\u0006I!!\u0017\u0002\u0011\r|g\u000e^3yi\u0002B\u0001\"!\u001a3A\u0013%\u0011qE\u0001\rM\u0016$8\r[*uKB\u001cV-\u001d\u0005\b\u0003S\u0012D\u0011AA6\u0003A9W\r^*qK\u000eLg-[2bi&|g.F\u0001X\u0011\u001d\tyG\rC\u0001\u0003c\n\u0001bZ3u'R,\u0007o\u001d\u000b\u0003\u0003g\u0002b!!\u001e\u0002|\u00055SBAA<\u0015\r\tI\bO\u0001\u0005kRLG.\u0003\u0003\u0002~\u0005]$\u0001\u0002'jgRDq!!!3\t\u0003\t\u0019)A\u0004hKR\u001cF/\u001a9\u0015\t\u00055\u0013Q\u0011\u0005\b\u0003\u000f\u000by\b1\u0001~\u0003\tq'\u000fC\u0004\u0002\u0002J\"\t!a#\u0015\t\u00055\u0013Q\u0012\u0005\t\u0003\u001f\u000bI\t1\u0001\u0002H\u0005!\u0001/\u0019;i\u0011\u001d\t\u0019J\rC\u0001\u0003+\u000b\u0001bZ3u'R\fG/\u001a\u000b\u0003\u0003\u000bAq!!'3\t\u0003\tY*A\u0003hKRLE\r\u0006\u0002\u0002\u001eB!\u0011qTAS\u001d\r\u0019\u0012\u0011U\u0005\u0004\u0003G#\u0012A\u0002)sK\u0012,g-C\u0002{\u0003OS1!a)\u0015\u0011\u001d\tYK\rC\u0001\u00037\u000babZ3u\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u00020J\"\t!!-\u0002\u0019\u001d,Go\u0015;beR$\u0015\r^3\u0015\u0003!Dq!!.3\t\u0003\t\t,A\thKR\u001cu.\u001c9mKRLwN\u001c#bi\u0016Dq!!/3\t\u0003\tY,\u0001\u0006hKRt%o\u0015;faN$\u0012! \u0005\b\u0003\u007f\u0013D\u0011AA^\u0003A9W\r^\"veJ,g\u000e^*uKBt%\u000fC\u0004\u0002DJ\"\t!!2\u0002'\u001d,GoQ;se\u0016tGo\u0015;faB\u000bG\u000f[:\u0016\u0005\u0005\u001d\u0007CBA;\u0003w\n9\u0005C\u0004\u0002LJ\"\t!!4\u0002#\u001d,GoQ;se\u0016tGo\u0015;fa:\u00138\u000f\u0006\u0002\u0002PB1\u0011QOA>\u0003#\u00042!NAj\u0013\r\t)N\u000e\u0002\b\u0013:$XmZ3s\u0011\u001d\tIN\rC\u0001\u00037\f1bZ3u\u001b\u0016$\u0018\rZ1uCR\u0011\u0011Q\u001c\t\t\u0003k\ny.!(\u0002\u001e&!\u0011\u0011]A<\u0005\ri\u0015\r\u001d\u0005\b\u0003K\u0014D\u0011AA^\u0003=9W\r\u001e$bS2,(/Z\"pk:$\bbBAue\u0011\u0005\u00111T\u0001\tO\u0016$xj\u001e8fe\"9\u0011Q\u001e\u001a\u0005\u0002\u0005=\u0018\u0001C:fi>;h.\u001a:\u0015\t\u0005U\u0011\u0011\u001f\u0005\t\u0003g\fY\u000f1\u0001\u0002\u001e\u0006Aa.Z<Po:,'\u000fC\u0004\u0002xJ\"\t!!?\u0002\u001d\u001d,G\u000fV3na^{'o\u001b#jeV\u0011\u00111 \t\u0004\u0011\u0006u\u0018bAA\u0000\u0013\n!a)\u001b7f\u0011!\u0011\u0019A\rC\u0001\u0005\t\u0015\u0011\u0001C:fiN#\u0018\r^3\u0015\t\u0005U!q\u0001\u0005\t\u0003\u0007\u0011\t\u00011\u0001\u0002\u0006!A!1\u0002\u001a\u0005\u0002\t\u0011i!A\u0007sK\u000e|'\u000f\u001a$bS2,(/\u001a\u000b\u0003\u0003+A\u0001B!\u00053\t\u0003\u0011!QB\u0001\fe\u0016\u001cwN\u001d3Ti\u0006\u0014H\u000f\u0003\u0005\u0003\u0016I\"\tA\u0001B\u0007\u0003A\u0011XmY8sI\u000e{W\u000e\u001d7fi&|g\u000eC\u0004\u0003\u001aI\"\t!a\u0016\u0002\u0015\u001d,GoQ8oi\u0016DH\u000f\u0003\u0005\u0003\u001eI\"\tA\u0001B\u0010\u0003!9W\r\u001e\"m_\u000e\\G#A2\t\u000f\tu!\u0007\"\u0001\u0003$Q\u00191M!\n\t\u0011\u0005=%\u0011\u0005a\u0001\u0003\u000fB\u0001B!\u000b3A\u0013%!1F\u0001\u0012g\u0016$8\u000b^1uK\u0006sGMT8uS\u001aLHC\u0002B\u0017\u0005\u0007\u0012Y\u0005\u0006\u0003\u0002\u0016\t=\u0002\u0002\u0003B\u0019\u0005O\u0001\u001dAa\r\u0002\rML8\u000f^3n!\u0011\u0011)Da\u0010\u000e\u0005\t]\"\u0002\u0002B\u001d\u0005w\tQ!Y2u_JT!A!\u0010\u0002\t\u0005\\7.Y\u0005\u0005\u0005\u0003\u00129DA\u0006BGR|'oU=ti\u0016l\u0007\u0002CA\u0002\u0005O\u0001\rA!\u0012\u0011\u0007u\u00129%C\u0002\u0003Jy\u0012!c\u0015;fa\u0016CXmY;uS>t7\u000b^1uK\"A!Q\nB\u0014\u0001\u0004\u0011y%\u0001\u0003ti\u0016\u0004\bc\u0001\b\u0003R%\u0019!1\u000b\u0002\u0003\u0011Q\u000b7o[*uKBD\u0001Ba\u00163\t\u0003\u0011!\u0011L\u0001\u0016g\u0016$H+Y:l'R\fG/Z!oI:{G/\u001b4z)\u0011\u0011YFa\u0018\u0015\t\u0005U!Q\f\u0005\t\u0005c\u0011)\u0006q\u0001\u00034!A!\u0011\rB+\u0001\u0004\t)!\u0001\u0005oK^\u001cF/\u0019;f\u0011%\u0011)G\rb\u0001\n\u0003\u00119'A\ntW&\u0004\b/\u00192mKR\u000b7o[*uCR,7/\u0006\u0002\u0003jA1!1\u000eB;\u0003\u000bi!A!\u001c\u000b\t\t=$\u0011O\u0001\nS6lW\u000f^1cY\u0016T1Aa\u001d\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005o\u0012iGA\u0002TKRD\u0001Ba\u001f3A\u0003%!\u0011N\u0001\u0015g.L\u0007\u000f]1cY\u0016$\u0016m]6Ti\u0006$Xm\u001d\u0011\t\u0011\t}$\u0007\"\u0001\u0003\u0005\u0003\u000bAa]6jaR!!1\u0011BD)\u0011\t)B!\"\t\u0011\tE\"Q\u0010a\u0002\u0005gA\u0001B!#\u0003~\u0001\u0007!1R\u0001\bgR,\u0007O\u0014:t!\u0015\tYC!$~\u0013\u0011\ti(!\u0010\t\u0011\tE%\u0007\"\u0001\u0003\u0005'\u000ba!\u001e8tW&\u0004H\u0003\u0002BK\u00053#B!!\u0006\u0003\u0018\"A!\u0011\u0007BH\u0001\b\u0011\u0019\u0004\u0003\u0005\u0003\n\n=\u0005\u0019\u0001BF\u0011!\u0011iJ\rC\u0001\u0005\t}\u0015!C:lSB\u0004\u0016\r\u001e5t)\u0011\u0011\tK!*\u0015\t\u0005U!1\u0015\u0005\t\u0005c\u0011Y\nq\u0001\u00034!A!\u0011\u0012BN\u0001\u0004\u00119\u000b\u0005\u0004\u0002,\t5\u0015q\t\u0005\t\u0005W\u0013D\u0011\u0001\u0002\u0003.\u0006YQO\\:lSB\u0004\u0016\r\u001e5t)\u0011\u0011yKa-\u0015\t\u0005U!\u0011\u0017\u0005\t\u0005c\u0011I\u000bq\u0001\u00034!A!\u0011\u0012BU\u0001\u0004\u00119\u000b\u0003\u0005\u00038J\"\tA\u0001B]\u0003!iwN^3Ti\u0016\u0004HCBA\u000b\u0005w\u0013y\fC\u0004\u0003>\nU\u0006\u0019A?\u0002\rM$X\r\u001d(s\u0011\u001d\u0011\tM!.A\u0002u\f1B\\3x!>\u001c\u0018\u000e^5p]\"9!Q\u0019\u001a\u0005\u0002\t\u001d\u0017\u0001C1eIB\u000bWo]3\u0015\t\u0005U!\u0011\u001a\u0005\t\u0005\u0017\u0014\u0019\r1\u0001\u0002R\u0006A\u0001o\\:ji&|g\u000eC\u0004\u0003FJ\"\tAa4\u0015\t\u0005U!\u0011\u001b\u0005\t\u0005\u0017\u0014i\r1\u0001\u0002H!9!Q\u001b\u001a\u0005\u0002\t5\u0011!\u0003:fG>4XM]3e\u0011!\u0011IN\rC\u0001\u0005\tm\u0017!D:uKBt%\u000fV8J]\u0012,\u0007\u0010F\u0002~\u0005;DqA!0\u0003X\u0002\u0007Q\u0010C\u0004\u0003bJ\"\tAa9\u0002\u0017\r\fgNQ3Rk\u0016,X\rZ\u000b\u0003\u0005K\u00042a\u0005Bt\u0013\r\u0011I\u000f\u0006\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011iO\rC!\u00037\u000b\u0001\u0002^8TiJLgn\u001a\u0005\b\u0005c\u0014D\u0011AAY\u0003A9W\r^*dQ\u0016$W\u000f\\3e\t\u0006$X\rC\u0004\u0003vJ\"\tAa>\u0002!M,GoU2iK\u0012,H.\u001a3ECR,G\u0003BA\u000b\u0005sDa!\u001eBz\u0001\u0004A\u0007b\u0002B\u007fe\u0011\u0005!q`\u0001\u0010O\u0016$\u0018i\u0019;jm\u0016\u0014En\\2lgR\u00111\u0011\u0001\t\u0007\u0003k\nY(!(\t\u0013\r\u0015!G1A\u0005\u0002\r\u001d\u0011!E1di&4XM\u00117pG.\u001cF/\u0019;fgV\u00111\u0011\u0002\t\u0007\u0005W\u0012)ha\u0003\u0011\u0007u\u001ai!C\u0002\u0004\u0010y\u00121C\u00117pG.,\u00050Z2vi&|gn\u0015;bi\u0016D\u0001ba\u00053A\u0003%1\u0011B\u0001\u0013C\u000e$\u0018N^3CY>\u001c7n\u0015;bi\u0016\u001c\b\u0005\u0003\u0005\u0004\u0018I\u0002K\u0011BB\r\u00031\t7\r^5wK\ncwnY6t)\u0011\u0019Yb!\b\u0011\r\u0005-\"QRAO\u0011\u0019\u00117Q\u0003a\u0001G\"91\u0011E\u0016A\u0002\u0005m\u0018\u0001\u00024jY\u0016D\u0011b!\n\u0010\u0003\u0003%Iaa\n\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002i\u0001")
public class Task
implements TaskWithSteps,
TaskWithBlock,
Serializable {
    private final String id;
    private final TaskSpecification spec;
    private DateTime startDate;
    private DateTime completionDate;
    private DateTime scheduledDate;
    private String owner;
    private int failureCount;
    public TaskExecutionState com$xebialabs$deployit$engine$tasker$Task$$state;
    private Block block;
    private final TaskExecutionContext context;
    private final Set<TaskExecutionState> skippableTaskStates;
    private final Set<BlockExecutionState> activeBlockStates;

    public static Option<Task> apply(File file) {
        return Task$.MODULE$.apply(file);
    }

    public static Logger logger() {
        return Task$.MODULE$.logger();
    }

    public Block block() {
        return this.block;
    }

    public void block_$eq(Block x$1) {
        this.block = x$1;
    }

    public IndexedSeq<Tuple2<Tuple2<BlockPath, StepState>, Object>> com$xebialabs$deployit$engine$tasker$Task$$steps() {
        return this.fetchStepSeq();
    }

    public TaskExecutionContext context() {
        return this.context;
    }

    private IndexedSeq<Tuple2<Tuple2<BlockPath, StepState>, Object>> fetchStepSeq() {
        return ((TraversableOnce)this.block().getStepsWithPaths().zipWithIndex(Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
    }

    public TaskSpecification getSpecification() {
        return this.spec;
    }

    public java.util.List<StepState> getSteps() {
        return package$.MODULE$.wrapAll().seqAsJavaList((Seq)((TraversableOnce)this.com$xebialabs$deployit$engine$tasker$Task$$steps().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StepState apply(Tuple2<Tuple2<BlockPath, StepState>, Object> x$1) {
                return (StepState)((Tuple2)x$1._1())._2();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toList());
    }

    public StepState getStep(int nr) {
        return (StepState)((Tuple2)((Tuple2)this.com$xebialabs$deployit$engine$tasker$Task$$steps().apply(this.stepNrToIndex(nr)))._1())._2();
    }

    public StepState getStep(BlockPath path) {
        return this.block().getStep(path.tail());
    }

    public TaskExecutionState getState() {
        return this.com$xebialabs$deployit$engine$tasker$Task$$state;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.spec.getDescription();
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getCompletionDate() {
        return this.completionDate;
    }

    public int getNrSteps() {
        return this.com$xebialabs$deployit$engine$tasker$Task$$steps().size();
    }

    public int getCurrentStepNr() {
        return BoxesRunTime.unboxToInt((Object)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(this.getCurrentStepNrs()).headOption().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x) {
                return Predef$.MODULE$.Integer2int(x);
            }
        }).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Task $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                TaskExecutionState taskExecutionState = this.$outer.com$xebialabs$deployit$engine$tasker$Task$$state;
                TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTED;
                return !(taskExecutionState != null ? !taskExecutionState.equals(taskExecutionState2) : taskExecutionState2 != null) ? this.$outer.com$xebialabs$deployit$engine$tasker$Task$$steps().size() : 0;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public java.util.List<BlockPath> getCurrentStepPaths() {
        return package$.MODULE$.wrapAll().seqAsJavaList((Seq)this.block().getStepsWithPaths().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<BlockPath, StepState>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    BlockPath path = (BlockPath)A1._1();
                    StepState step2 = (StepState)A1._2();
                    if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StepExecutionState[]{StepExecutionState.EXECUTING, StepExecutionState.FAILED, StepExecutionState.PAUSED}))).contains((Object)step2.getState())) {
                        object = path;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<BlockPath, StepState> x2) {
                Tuple2<BlockPath, StepState> tuple2 = x2;
                if (tuple2 == null) return false;
                StepState step2 = (StepState)tuple2._2();
                if (!((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StepExecutionState[]{StepExecutionState.EXECUTING, StepExecutionState.FAILED, StepExecutionState.PAUSED}))).contains((Object)step2.getState())) return false;
                return true;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    /*
     * Unable to fully structure code
     */
    public java.util.List<Integer> getCurrentStepNrs() {
        mySteps = this.com$xebialabs$deployit$engine$tasker$Task$$steps();
        activeStates = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StepExecutionState[]{StepExecutionState.EXECUTING, StepExecutionState.FAILED, StepExecutionState.PAUSED}));
        list = ((TraversableOnce)this.com$xebialabs$deployit$engine$tasker$Task$$steps().view().filter((Function1)new scala.Serializable(this, activeStates){
            public static final long serialVersionUID = 0L;
            private final Set activeStates$1;

            public final boolean apply(Tuple2<Tuple2<BlockPath, StepState>, Object> t) {
                return this.activeStates$1.contains((Object)((StepState)((Tuple2)t._1())._2()).getState());
            }
            {
                this.activeStates$1 = activeStates$1;
            }
        }).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(Tuple2<Tuple2<BlockPath, StepState>, Object> t) {
                return Predef$.MODULE$.int2Integer(t._2$mcI$sp() + 1);
            }
        }, SeqView$.MODULE$.canBuildFrom())).toList();
        var5_4 = false;
        var6_5 = null;
        var7_6 = list;
        v0 = Nil$.MODULE$;
        var8_7 = var7_6;
        if (v0 != null ? v0.equals(var8_7) == false : var8_7 != null) ** GOTO lbl-1000
        var5_4 = true;
        var6_5 = var7_6;
        v1 = this.com$xebialabs$deployit$engine$tasker$Task$$state;
        var9_8 = TaskExecutionState.EXECUTED;
        if (!(v1 != null ? v1.equals(var9_8) == false : var9_8 != null)) {
            var10_9 = package$.MODULE$.wrapAll().seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(mySteps.size())})));
        } else lbl-1000:
        // 2 sources

        {
            var10_9 = var5_4 != false && ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TaskExecutionState[]{TaskExecutionState.STOPPED, TaskExecutionState.ABORTED}))).contains((Object)this.com$xebialabs$deployit$engine$tasker$Task$$state) != false ? package$.MODULE$.wrapAll().seqAsJavaList((Seq)((TraversableLike)mySteps.map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Tuple2<BlockPath, StepState>, Object> x$4) {
                    return x$4._2$mcI$sp();
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(this, mySteps){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Task $outer;
                private final IndexedSeq mySteps$1;

                public final <A1, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    Object object = this.$outer.com$xebialabs$deployit$engine$tasker$Task$$stepByIdxIs$1((int)A1, StepExecutionState.DONE, this.mySteps$1) && this.$outer.com$xebialabs$deployit$engine$tasker$Task$$stepByIdxIs$1((int)(A1 + true), StepExecutionState.PENDING, this.mySteps$1) ? Predef$.MODULE$.int2Integer((int)(A1 + true)) : function1.apply((Object)BoxesRunTime.boxToInteger(x4));
                    return (B1)object;
                }

                public final boolean isDefinedAt(int x4) {
                    int n = x4;
                    boolean bl = this.$outer.com$xebialabs$deployit$engine$tasker$Task$$stepByIdxIs$1(n, StepExecutionState.DONE, this.mySteps$1) && this.$outer.com$xebialabs$deployit$engine$tasker$Task$$stepByIdxIs$1(n + 1, StepExecutionState.PENDING, this.mySteps$1);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.mySteps$1 = mySteps$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())) : (var5_4 != false ? package$.MODULE$.wrapAll().seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}))) : package$.MODULE$.wrapAll().seqAsJavaList((Seq)var7_6));
        }
        res = var10_9;
        return res;
    }

    public Map<String, String> getMetadata() {
        return this.spec.getMetadata();
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String newOwner) {
        this.owner = newOwner;
    }

    public File getTempWorkDir() {
        return this.spec.getTempWorkDir();
    }

    public void setState(TaskExecutionState state) {
        this.com$xebialabs$deployit$engine$tasker$Task$$state = state;
    }

    public void recordFailure() {
        ++this.failureCount;
    }

    public void recordStart() {
        if (this.startDate == null) {
            this.startDate = new DateTime(DateTimeZone.UTC);
        }
    }

    public void recordCompletion() {
        this.completionDate = new DateTime(DateTimeZone.UTC);
    }

    public TaskExecutionContext getContext() {
        return this.context();
    }

    public Block getBlock() {
        return this.block();
    }

    public Block getBlock(BlockPath path) {
        return this.block().getBlock(path.tail());
    }

    public void com$xebialabs$deployit$engine$tasker$Task$$setStateAndNotify(StepExecutionState state, TaskStep step2, ActorSystem system) {
        StepExecutionState oldState = step2.getState();
        step2.setState(state);
        system.eventStream().publish((Object)new StateChangeEventListenerActor.StepStateEvent(this.getId(), UUID.randomUUID().toString(), this, step2, oldState, state, (Option<TaskExecutionContext>)None$.MODULE$));
    }

    public void setTaskStateAndNotify(TaskExecutionState newState, ActorSystem system) {
        TaskExecutionState oldState = this.com$xebialabs$deployit$engine$tasker$Task$$state;
        this.com$xebialabs$deployit$engine$tasker$Task$$state = newState;
        Task$.MODULE$.logger().info((Function0)new scala.Serializable(this, newState, oldState){
            public static final long serialVersionUID = 0L;
            private final TaskExecutionState newState$1;
            private final TaskExecutionState oldState$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Publishing state change ", " -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.oldState$1, this.newState$1}));
            }
            {
                this.newState$1 = newState$1;
                this.oldState$1 = oldState$1;
            }
        });
        system.eventStream().publish((Object)new StateChangeEventListenerActor.TaskStateEvent(this.getId(), this, oldState, newState));
    }

    public Set<TaskExecutionState> skippableTaskStates() {
        return this.skippableTaskStates;
    }

    public void skip(List<Object> stepNrs, ActorSystem system) {
        if (this.skippableTaskStates().contains((Object)this.com$xebialabs$deployit$engine$tasker$Task$$state)) {
            Try try_ = Try$.MODULE$.apply((Function0)new $anonfun$2(this, stepNrs, system));
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new TaskerException(ex, "Could not skip all steps");
            }
            throw new MatchError((Object)try_);
        }
        throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task [", "] should be PENDING or STOPPED, but was [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id, this.com$xebialabs$deployit$engine$tasker$Task$$state})));
    }

    public void unskip(List<Object> stepNrs, ActorSystem system) {
        if (this.skippableTaskStates().contains((Object)this.com$xebialabs$deployit$engine$tasker$Task$$state)) {
            Try try_ = Try$.MODULE$.apply((Function0)new $anonfun$3(this, stepNrs, system));
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new TaskerException(ex, "Could not skip all steps");
            }
            throw new MatchError((Object)try_);
        }
        throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task [", "] should be PENDING or STOPPED, but was [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id, this.com$xebialabs$deployit$engine$tasker$Task$$state})));
    }

    public void skipPaths(List<BlockPath> stepNrs, ActorSystem system) {
        if (this.skippableTaskStates().contains((Object)this.com$xebialabs$deployit$engine$tasker$Task$$state)) {
            Try try_ = Try$.MODULE$.apply((Function0)new $anonfun$4(this, stepNrs, system));
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new TaskerException(ex, "Could not skip all steps");
            }
            throw new MatchError((Object)try_);
        }
        throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task [", "] should be PENDING or STOPPED, but was [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id, this.com$xebialabs$deployit$engine$tasker$Task$$state})));
    }

    public void unskipPaths(List<BlockPath> stepNrs, ActorSystem system) {
        if (this.skippableTaskStates().contains((Object)this.com$xebialabs$deployit$engine$tasker$Task$$state)) {
            Try try_ = Try$.MODULE$.apply((Function0)new $anonfun$5(this, stepNrs, system));
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new TaskerException(ex, "Could not unskip all steps");
            }
            throw new MatchError((Object)try_);
        }
        throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task [", "] should be PENDING or STOPPED, but was [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id, this.com$xebialabs$deployit$engine$tasker$Task$$state})));
    }

    public void moveStep(int stepNr, int newPosition) {
        TaskExecutionState taskExecutionState = this.com$xebialabs$deployit$engine$tasker$Task$$state;
        TaskExecutionState taskExecutionState2 = TaskExecutionState.PENDING;
        if (!(taskExecutionState != null ? !taskExecutionState.equals(taskExecutionState2) : taskExecutionState2 != null) && this.getCurrentStepNr() == 0) {
            if (this.block() instanceof StepBlock) {
                int oldIdx = this.stepNrToIndex(stepNr);
                int newIdx = this.stepNrToIndex(newPosition);
                StepBlock stepBlock = (StepBlock)this.block();
                ListBuffer<StepState> stepBuffer = stepBlock.steps();
                StepState removed = (StepState)stepBuffer.remove(oldIdx);
                stepBuffer.insert(newIdx, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new StepState[]{removed}));
                return;
            }
            throw new TaskerException("Cannot move steps when the task consists of multiple blocks");
        }
        throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task [", "] should not have run when moving steps"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id})));
    }

    public void addPause(Integer position) {
        if (this.block() instanceof StepBlock) {
            if (this.getCurrentStepNr() >= Predef$.MODULE$.Integer2int(position)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can only add pause steps after the current execution position (currently: [", "], requested: [", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.getCurrentStepNr()), position})));
            }
            StepBlock stepBlock = (StepBlock)this.block();
            ListBuffer<StepState> stepBuffer = stepBlock.steps();
            stepBuffer.insert(this.stepNrToIndex(Predef$.MODULE$.Integer2int(position)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new StepState[]{new TaskStep(new PauseStep())}));
            return;
        }
        throw new TaskerException("Cannot add pause step using old Integer index when the task consists of multiple blocks");
    }

    public void addPause(BlockPath position) {
        if (this.canBeQueued()) {
            this.block().addPause(position.tail());
            return;
        }
        throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task [", "] should be PENDING, STOPPED, ABORTED or QUEUED but was [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id, this.com$xebialabs$deployit$engine$tasker$Task$$state})));
    }

    public void recovered() {
        boolean bl;
        TaskExecutionState taskExecutionState = this.com$xebialabs$deployit$engine$tasker$Task$$state;
        TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTING;
        TaskExecutionState taskExecutionState3 = taskExecutionState;
        if (!(taskExecutionState2 != null ? !taskExecutionState2.equals(taskExecutionState3) : taskExecutionState3 != null)) {
            bl = true;
        } else {
            TaskExecutionState taskExecutionState4 = TaskExecutionState.STOPPING;
            TaskExecutionState taskExecutionState5 = taskExecutionState;
            if (!(taskExecutionState4 != null ? !taskExecutionState4.equals(taskExecutionState5) : taskExecutionState5 != null)) {
                bl = true;
            } else {
                TaskExecutionState taskExecutionState6 = TaskExecutionState.FAILING;
                TaskExecutionState taskExecutionState7 = taskExecutionState;
                if (!(taskExecutionState6 != null ? !taskExecutionState6.equals(taskExecutionState7) : taskExecutionState7 != null)) {
                    bl = true;
                } else {
                    TaskExecutionState taskExecutionState8 = TaskExecutionState.ABORTING;
                    TaskExecutionState taskExecutionState9 = taskExecutionState;
                    bl = !(taskExecutionState8 != null ? !taskExecutionState8.equals(taskExecutionState9) : taskExecutionState9 != null);
                }
            }
        }
        TaskExecutionState taskExecutionState10 = bl ? TaskExecutionState.FAILED : this.com$xebialabs$deployit$engine$tasker$Task$$state;
        this.com$xebialabs$deployit$engine$tasker$Task$$state = taskExecutionState10;
        this.block_$eq(this.block().recovered());
    }

    public int stepNrToIndex(int stepNr) {
        if (stepNr <= 0 || stepNr > this.com$xebialabs$deployit$engine$tasker$Task$$steps().size()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a valid step number [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stepNr)})));
        }
        return stepNr - 1;
    }

    public boolean canBeQueued() {
        return EnumSet.of(TaskExecutionState.PENDING, TaskExecutionState.STOPPED, TaskExecutionState.ABORTED, TaskExecutionState.FAILED).contains(this.com$xebialabs$deployit$engine$tasker$Task$$state);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task[", ", ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id, this.com$xebialabs$deployit$engine$tasker$Task$$state}));
    }

    public DateTime getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(DateTime scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public java.util.List<String> getActiveBlocks() {
        return package$.MODULE$.wrapAll().seqAsJavaList(this.com$xebialabs$deployit$engine$tasker$Task$$activeBlocks(this.block()));
    }

    public Set<BlockExecutionState> activeBlockStates() {
        return this.activeBlockStates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> com$xebialabs$deployit$engine$tasker$Task$$activeBlocks(Block block) {
        boolean bl = false;
        CompositeBlock compositeBlock = null;
        Block block2 = block;
        if (block2 instanceof CompositeBlock) {
            bl = true;
            compositeBlock = (CompositeBlock)block2;
            if (this.activeBlockStates().contains((Object)compositeBlock.state())) {
                String string = compositeBlock.getId();
                return ((TraversableOnce)compositeBlock.blocks().flatMap((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Task $outer;

                    public final List<String> apply(Block block) {
                        return this.$outer.com$xebialabs$deployit$engine$tasker$Task$$activeBlocks(block);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toList().$colon$colon((Object)string);
            }
        }
        if (bl) {
            return Nil$.MODULE$;
        }
        if (block2 == null) return Nil$.MODULE$;
        Block block3 = block2;
        if (!this.activeBlockStates().contains((Object)block3.state())) return Nil$.MODULE$;
        String string = block3.getId();
        return Nil$.MODULE$.$colon$colon((Object)string);
    }

    public final boolean com$xebialabs$deployit$engine$tasker$Task$$stepByIdxIs$1(int idx, StepExecutionState s, IndexedSeq mySteps$1) {
        Option option = mySteps$1.find((Function1)new scala.Serializable(this, idx){
            public static final long serialVersionUID = 0L;
            private final int idx$1;

            public final boolean apply(Tuple2<Tuple2<BlockPath, StepState>, Object> x$2) {
                return x$2._2$mcI$sp() == this.idx$1;
            }
            {
                this.idx$1 = idx$1;
            }
        }).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StepExecutionState apply(Tuple2<Tuple2<BlockPath, StepState>, Object> x$3) {
                return ((StepState)((Tuple2)x$3._1())._2()).getState();
            }
        });
        Some some = new Some((Object)s);
        return !(option != null ? !option.equals(some) : some != null);
    }

    public Task(String id, TaskSpecification spec) {
        this.id = id;
        this.spec = spec;
        this.startDate = null;
        this.completionDate = null;
        this.scheduledDate = null;
        this.owner = spec.getOwner();
        this.failureCount = 0;
        this.com$xebialabs$deployit$engine$tasker$Task$$state = TaskExecutionState.UNREGISTERED;
        this.block = spec.getBlock();
        this.context = new TaskExecutionContext((Option<TaskExecutionContext>)None$.MODULE$, spec);
        if (spec.getInspectionContext() != null) {
            spec.getInspectionContext().registerTask(this);
        }
        this.skippableTaskStates = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TaskExecutionState[]{TaskExecutionState.PENDING, TaskExecutionState.STOPPED, TaskExecutionState.FAILED, TaskExecutionState.ABORTED}));
        this.activeBlockStates = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlockExecutionState[]{BlockExecutionState.EXECUTING, BlockExecutionState.FAILING, BlockExecutionState.STOPPING, BlockExecutionState.ABORTING}));
    }

    public Task(String id, Block block) {
        this(id, new TaskSpecification("", "", block));
    }
}

