package com.xebialabs.deployit.engine.tasker

import akka.actor.{ActorContext, ActorRef, PoisonPill, Actor}
import grizzled.slf4j.Logging

trait Samurai extends Logging {

  protected def `i'm dead`: Actor.Receive = {
    case m: Any => warn(s"I'm dead and cannot process $m")
  }

  def harakiri(logMessage: String = "")(implicit self: ActorRef, context: ActorContext) {
    debug(s"$logMessage - harakiri on $self")
    self ! PoisonPill
    context.become(`i'm dead`)
  }
}
