package com.xebialabs.deployit.engine.tasker.satellite

import akka.actor.ExtendedActorSystem
import com.esotericsoftware.kryo.Kryo
import com.esotericsoftware.kryo.serializers.FieldSerializer
import com.xebialabs.deployit.engine.tasker.TaskStep

class TaskStepSerializer(kryo: Kryo) extends FieldSerializer[TaskStepSerializer](kryo, classOf[TaskStep]) {
  override def initializeCachedFields() {
    getFields.find(_.getField.getName == "implementation").foreach(field => super.removeField(field.getField.getName))

  }
}

object TaskStepSerializer {
  private[satellite] def kryo(system: ExtendedActorSystem) = {
    val kryo = KryoSerializer.getMagicCombination(system)
    kryo.register(classOf[TaskStep], new TaskStepSerializer(kryo))
    kryo
  }

}