package com.xebialabs.deployit.engine.tasker.log

import com.xebialabs.deployit.engine.tasker.{BlockPath, TaskId, TaskStep}

class DefaultStepLogFactory extends StepLogFactory {
  override def create(taskId: TaskId, stepPath: BlockPath, step: TaskStep): StepLog = new DefaultStepLog(step)
}

class DefaultStepLog(step: TaskStep) extends StepLog {

  protected def doAppendLog(s: String*): Unit = s.foreach(step.appendLog)

  override def markNextAttempt(): Unit = step.markNextAttempt()
}
