/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import akka.actor.ActorRef;
import com.typesafe.config.Config;
import com.xebialabs.deployit.engine.tasker.EnqueueTaskErrorHandler;
import com.xebialabs.deployit.engine.tasker.EnqueueTaskListener;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import javax.jms.MessageListener;
import org.slf4j.Marker;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.SimpleJmsListenerEndpoint;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.util.ErrorHandler;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class EnqueueTaskListener$
implements Logging {
    public static final EnqueueTaskListener$ MODULE$ = new EnqueueTaskListener$();
    private static List<DefaultMessageListenerContainer> listeners;
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$((Logging)MODULE$);
        listeners = package$.MODULE$.Nil();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnqueueTaskListener$ enqueueTaskListener$ = this;
        synchronized (enqueueTaskListener$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : grizzled$slf4j$Logging$$_logger;
    }

    public List<DefaultMessageListenerContainer> listeners() {
        return listeners;
    }

    public void listeners_$eq(List<DefaultMessageListenerContainer> x$1) {
        listeners = x$1;
    }

    public void registerTaskListenerContainers(String workerAddress, ActorRef taskReceiver, JmsListenerContainerFactory<DefaultMessageListenerContainer> containerFactory, Config config) {
        String taskQueueName = config.getString("xl.task.queue.name");
        this.listeners_$eq((List<DefaultMessageListenerContainer>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefaultMessageListenerContainer[]{this.initListener(containerFactory, this.createEndpoint(taskQueueName, workerAddress, taskReceiver), this.initListener$default$3()), this.initListener(containerFactory, this.createRollbackEndpoint(taskQueueName, workerAddress, taskReceiver), true)}))));
    }

    public void startListeners() {
        this.listeners().foreach((Function1 & Serializable)listener -> {
            EnqueueTaskListener$.MODULE$.startListener(listener);
            return BoxedUnit.UNIT;
        });
    }

    public void stopListeners() {
        this.listeners().foreach((Function1 & Serializable)listener -> {
            EnqueueTaskListener$.MODULE$.stopListener(listener);
            return BoxedUnit.UNIT;
        });
    }

    public void shutdownListeners() {
        this.listeners().foreach((Function1 & Serializable)listener -> {
            EnqueueTaskListener$.MODULE$.shutdownListener(listener);
            return BoxedUnit.UNIT;
        });
    }

    private DefaultMessageListenerContainer initListener(JmsListenerContainerFactory<DefaultMessageListenerContainer> containerFactory, SimpleJmsListenerEndpoint endpoint, boolean isRollback) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("Creating for endpoint [").append(endpoint.getId()).append("]").toString());
        DefaultMessageListenerContainer container = (DefaultMessageListenerContainer)containerFactory.createListenerContainer((JmsListenerEndpoint)endpoint);
        container.setErrorHandler((ErrorHandler)new EnqueueTaskErrorHandler(endpoint.getDestination(), isRollback));
        container.setPubSubDomain(isRollback);
        container.initialize();
        return container;
    }

    private boolean initListener$default$3() {
        return false;
    }

    private SimpleJmsListenerEndpoint createEndpoint(String taskQueueName, String workerAddress, ActorRef taskReceiver) {
        return this.newEndpoint(taskReceiver, workerAddress, taskQueueName, this.newEndpoint$default$4());
    }

    private SimpleJmsListenerEndpoint createRollbackEndpoint(String taskQueueName, String workerAddress, ActorRef taskReceiver) {
        return this.newEndpoint(taskReceiver, new StringBuilder(9).append(workerAddress).append("-rollback").toString(), workerAddress, (Option<String>)new Some((Object)new StringBuilder(18).append("workerAddress = '").append(workerAddress).append("'").toString()));
    }

    private SimpleJmsListenerEndpoint newEndpoint(ActorRef taskReceiver, String id, String destination, Option<String> selector) {
        SimpleJmsListenerEndpoint endpoint = new SimpleJmsListenerEndpoint();
        endpoint.setId(id);
        endpoint.setDestination(destination);
        endpoint.setMessageListener((MessageListener)new EnqueueTaskListener(taskReceiver));
        selector.foreach((Function1 & Serializable)x$1 -> {
            endpoint.setSelector(x$1);
            return BoxedUnit.UNIT;
        });
        return endpoint;
    }

    private Option<String> newEndpoint$default$4() {
        return None$.MODULE$;
    }

    private void startListener(DefaultMessageListenerContainer listener) {
        block0: {
            if (listener.isRunning()) break block0;
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(50).append("Starting the container listener for destination [").append(listener.getDestinationName()).append("]").toString());
            listener.start();
        }
    }

    private void stopListener(DefaultMessageListenerContainer listener) {
        block0: {
            if (!listener.isRunning()) break block0;
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(50).append("Stopping the container listener for destination [").append(listener.getDestinationName()).append("]").toString());
            listener.stop();
        }
    }

    private void shutdownListener(DefaultMessageListenerContainer listener) {
        block0: {
            if (!listener.isActive()) break block0;
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(55).append("Shutting down the container listener for destination [").append(listener.getDestinationName()).append("]").toString());
            listener.shutdown();
        }
    }

    private EnqueueTaskListener$() {
    }
}

