package com.xebialabs.deployit.engine.tasker.satellite

import java.nio.file.Path

import akka.actor.{ActorRef, ExtendedActorSystem}
import com.esotericsoftware.kryo.Kryo
import com.romix.akka.serialization.kryo.ActorRefSerializer
import com.romix.scala.serialization.kryo.{ScalaCollectionSerializer, ScalaImmutableMapSerializer, ScalaImmutableSetSerializer}
import com.twitter.chill.{AllScalaRegistrar, EmptyScalaKryoInstantiator}
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.utils.ClassLoaderUtils.classLoader
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer
import de.javakaffee.kryoserializers.jodatime.JodaDateTimeSerializer
import org.joda.time.DateTime

import scala.collection.mutable

object KryoSerializer {

  def getMagicCombination(system: ExtendedActorSystem): Kryo = {

    val kryo = new EmptyScalaKryoInstantiator().newKryo()

    kryo.register(scala.collection.immutable.Nil.getClass)

    // Serialization of Scala maps like Trees, etc
    kryo.addDefaultSerializer(classOf[scala.collection.Map[_, _]], classOf[ScalaImmutableMapSerializer])
    kryo.addDefaultSerializer(classOf[scala.collection.generic.MapFactory[scala.collection.Map]], classOf[ScalaImmutableMapSerializer])

    // Serialization of Scala sets
    kryo.addDefaultSerializer(classOf[scala.collection.Set[_]], classOf[ScalaImmutableSetSerializer])
    kryo.addDefaultSerializer(classOf[scala.collection.generic.SetFactory[scala.collection.Set]], classOf[ScalaImmutableSetSerializer])

    // Serialization of all Traversable Scala collections like Lists, Vectors, etc
    kryo.addDefaultSerializer(classOf[scala.collection.Traversable[_]], classOf[ScalaCollectionSerializer])
    UnmodifiableCollectionsSerializer.registerSerializers(kryo)

    ImmutableListSerializer.registerSerializers(kryo)

    kryo.addDefaultSerializer(classOf[ActorRef], new ActorRefSerializer(system))

    import scala.collection.JavaConverters._

    def useField[T](cls: Class[T]) {
      val fs = new com.esotericsoftware.kryo.serializers.FieldSerializer(kryo, cls)
      fs.setIgnoreSyntheticFields(false) // scala generates a lot of these attributes
      kryo.register(cls, fs)
    }

    // The wrappers are private classes:
    useField(Set(1, 2, 3).asJava.getClass)
    useField(Set(1, 2, 3).iterator.asJava.getClass)
    useField(mutable.Buffer(1, 2, 3).asJava.getClass)
    useField(mutable.Buffer(1, 2, 3).iterator.asJava.getClass)

    new AllScalaRegistrar().apply(kryo)

    kryo.addDefaultSerializer(classOf[DateTime], new JodaDateTimeSerializer)
    kryo.addDefaultSerializer(classOf[Type], new XlTypeSerializer)
    kryo.addDefaultSerializer(classOf[Path], new PathSerializer)

    kryo.setClassLoader(classLoader)

    kryo
  }

}
