package com.xebialabs.deployit.engine.tasker.log

import com.xebialabs.deployit.engine.api.execution.{BlockState, StepState}
import com.xebialabs.deployit.engine.tasker.{BlockPath, Task, TaskId}

trait StepLogRetriever {

  /**
    * Returns an instance that can retrieve logs from the step logs storage.
    *
    * @param taskId The taskId to retrieve logs for.
    * @param stepPath The path of the step to retrieve logs for.
    * @param step The step to retrieve logs for.
    * @return A step state instance that can be used to retrieve logs.
    *
    * @see [[com.xebialabs.deployit.engine.api.execution.StepState#getLog()]]
    * @see [[com.xebialabs.deployit.engine.api.execution.StepState#getPreviousAttemptsLogs()]]
    */
  def retrieveLogs(taskId: TaskId, stepPath: BlockPath, step: StepState): StepState

  /**
    * Returns an instance that can retrieve logs from the step logs storage.
    *
    * @param taskId The taskId to retrieve logs for.
    * @param block The step to retrieve logs for.
    * @return A block state instance that can be used to retrieve logs for all steps.
    *
    * @see [[com.xebialabs.deployit.engine.api.execution.BlockState#getSteps()]]
    * @see [[com.xebialabs.deployit.engine.api.execution.StepState#getLog()]]
    * @see [[com.xebialabs.deployit.engine.api.execution.StepState#getPreviousAttemptsLogs()]]
    */
  def retrieveLogs(taskId: TaskId, block: BlockState): BlockState

  /**
    * Retrieves all steps logs and stores them in the steps in the task.
    *
    * @param task The task to "fill" with logs.
    */
  def fillLogs(task: Task): Unit

  /**
    * Removes logs for the task from external systems (if applicable).
    *
    * @param taskId The id fo the task to remove logs for.
    */
  def removeLogs(taskId: TaskId)
}

