package com.xebialabs.deployit.engine.tasker

import akka.actor.{Actor, ActorContext, PoisonPill}
import grizzled.slf4j.Logging

trait Samurai extends Logging {

  def doNotAcceptMessages(logMessage: String = "")(implicit context: ActorContext): Unit = {
    debug(s"$logMessage - ignoring all messages from now on ${context.self}")
    context.become(`i'm dead`)
  }

  def harakiri(logMessage: String = "")(implicit context: ActorContext) {
    debug(s"$logMessage - harakiri on ${context.self}")
    context.become(`i'm dead`)
    context.self ! PoisonPill
  }

  private def `i'm dead`(implicit context: ActorContext): Actor.Receive = {
    case m: Any => context.system.deadLetters forward m
  }
}
