package com.xebialabs.xlplatform.test

import com.typesafe.config.{Config, ConfigFactory}
import org.yaml.snakeyaml.Yaml

import java.util.concurrent.TimeUnit
import scala.io.Source

object TestConfig {

  lazy val testConfig = {
    val resources: Config = ConfigFactory.load("test-config.conf")
    resources.getConfig("xl.platform.test")
  }

  object eventually {
    def timeout = testConfig.getDuration("eventually.timeout", TimeUnit.SECONDS)
    def interval = testConfig.getDuration("eventually.interval", TimeUnit.MILLISECONDS)
  }

  lazy val deployTaskConfig: Config = {
    ConfigFactory.parseMap(new Yaml().load(Source.fromResource("centralConfiguration/deploy-task.yaml").reader()))
  }

}
