package com.xebialabs.xlplatform.test

import java.io.{File, IOException}
import java.nio.file.{FileVisitOption, Files, Path}
import java.util.Comparator.reverseOrder
import scala.jdk.CollectionConverters._
import scala.jdk.StreamConverters._
import scala.language.implicitConversions

trait TempPathSugar {

  type DoWithPath[T] = Path => T

  def createTempPath(prefix: String = this.getClass.getName): Path = {
    Files.createTempDirectory(prefix)
  }

  def withTempPath[T](function: DoWithPath[T]): T = {
    val path: Path = createTempPath()
    try {
      function(path)
    } finally {
      path.deleteRecursively()
    }
  }

  implicit def path2File(path: Path): File = path.toFile

  implicit class PathUtils(path: Path) {
    def toNioPath: Path = path

    def deleteRecursively(ignoreErrors: Boolean = false): Any = {
      try {
        Files.walk(path, FileVisitOption.FOLLOW_LINKS)
          .sorted(reverseOrder[Path]())
          .toScala(Seq)
          .map(_.toFile())
          .foreach((f: File) => f.delete())
      } catch {
        case e: IOException => if (!ignoreErrors) throw e
      }
    }
    def createFile(): Path = {
      Files.createFile(path)
    }

    def createDirectory(createParents: Boolean = true): Path = {
      if (createParents) Files.createDirectories(path)
      else Files.createDirectory(path)
    }

    def write(content: String): Unit = {
      Files.write(path, Seq(content).asJava)
    }

    def delete(): Unit = Files.delete(path)

    def /(rest: String): Path = path.resolve(rest)

    def toPath: Path = path

    def jfile: File = path.toFile

    def *(filter: String): Seq[Path] = {
      Files.walk(path, 1).toScala(Seq).filter(_.endsWith(filter))
    }

  }

}
