package com.xebialabs.xlplatform.test

import java.net.{URL, URLClassLoader}

trait ClassLoaderSugar {
  def enhanceClassPath(resources: String*)(x: => Unit): Unit = {
    val currentClassLoader: ClassLoader = Thread.currentThread.getContextClassLoader
    val jarUrls: Seq[URL] = resources.map(currentClassLoader.getResource)
    val enchancedClassloader: URLClassLoader = new URLClassLoader(jarUrls.toArray, currentClassLoader)
    try {
      Thread.currentThread.setContextClassLoader(enchancedClassloader)
      x
    } finally {
      Thread.currentThread().setContextClassLoader(currentClassLoader)
    }
  }
}
