package com.xebialabs.xlplatform.test

import java.io.File
import java.nio.charset.StandardCharsets
import java.nio.file.Files

import org.scalatest.{BeforeAndAfterEach, Suite}

trait TmpElem

trait TmpFolder extends TmpElem

trait TmpFile extends TmpElem

case class folder(name: String, subs: TmpElem*) extends TmpElem

case class file(name: String, content: String = "") extends TmpElem

trait TemporaryDirectory extends BeforeAndAfterEach {
  self: Suite =>
  var tmpDir: File = _

  override protected def beforeEach(): Unit = {
    super.beforeEach()
    tmpDir = createDir("tmpdir")
  }

  override protected def afterEach(): Unit = {
    deleteDir(tmpDir)
    super.afterEach()
  }

  def mk(sub: TmpElem): File = {
    mk_(tmpDir, Seq(sub): _*).head
  }

  def mk_(current: File, subs: TmpElem*): Seq[File] = {
    subs.map {
      case f: file =>
        val newFile = new File(current, f.name)
        Files.write(newFile.toPath, f.content.getBytes(StandardCharsets.UTF_8))
        newFile
      case f: folder =>
        val newFolder = new File(current, f.name)
        newFolder.mkdirs()
        mk_(newFolder, f.subs: _*)
        newFolder
    }
  }

  protected def createDir(prefix: String): File = {
    val dir = File.createTempFile(prefix, "")
    dir.delete
    dir.mkdir
    dir
  }

  protected def deleteDir(dir: File): Unit = {
    Option(dir.listFiles).map(_.toList).getOrElse(Nil).foreach { file =>
      if (file.isDirectory) deleteDir(file) else file.delete
    }
    dir.delete
  }
}
