package com.xebialabs.xlplatform.test

import org.scalatest.concurrent.{Eventually => SEventually}
import org.scalatest.time.{Millis, Seconds, Span}

trait Eventually {

  private def timeout(factor: Double = 1.0) = SEventually.timeout(Span(TestConfig.eventually.timeout * factor, Seconds))

  private def interval(factor: Double = 1.0) = SEventually.interval(Span(TestConfig.eventually.interval * factor, Millis))

  def eventually[T](fun: => T) = SEventually.eventually(timeout(), interval())(fun)

  def eventually[T](factor: Double = 1.0)(fun: => T) = SEventually.eventually(timeout(factor), interval(factor))(fun)
}
