package com.xebialabs.xlplatform.test

import scalax.file.Path
import scalax.file.defaultfs.DefaultPath

trait TempPathSugar {

  type DoWithPath[T] = DefaultPath => T

  def createTempPath(prefix: String = this.getClass.getName) = Path.createTempDirectory(prefix = prefix, deleteOnExit = false)

  def withTempPath[T](function: DoWithPath[T]) = {
    val path: DefaultPath = createTempPath()
    try {
      function(path)
    } finally {
      path.deleteRecursively()
    }
  }

  implicit class PathUtils(path: Path) {
    def toNioPath = path.fileOption.map(_.toPath).get
  }
}
