package com.xebialabs.xlplatform.test

import java.util.concurrent.TimeUnit

import com.typesafe.config.Config
import com.typesafe.config.ConfigFactory._

object TestConfig {

  private lazy val testConfig = {
    val resources: Config = parseResources("test-config.conf")

    resources.getConfig("xl.platform.test")
  }

  object eventually {
    def timeout = testConfig.getDuration("eventually.timeout", TimeUnit.SECONDS)
    def interval = testConfig.getDuration("eventually.interval", TimeUnit.MILLISECONDS)
  }

}
