@echo off
REM
REM Batch script to start the XL Satellite Server
REM

setlocal ENABLEDELAYEDEXPANSION

REM Get Java executable
if "%JAVA_HOME%"=="" (
  set JAVACMD=java
) else (
  set JAVACMD="%JAVA_HOME%\bin\java"
)

REM Get XL Satellite server home dir
if "%XL_SATELLITE_SERVER_HOME%"=="" (
  cd /d "%~dp0"
  cd ..
  set XL_SATELLITE_SERVER_HOME=!CD!
)

cd /d "%XL_SATELLITE_SERVER_HOME%"

REM Build XL Satellite server classpath, JVM and logging options
FOR /F "tokens=1* delims==" %%A IN ('type "%XL_SATELLITE_SERVER_HOME%\conf\xl-satellite-wrapper-win.conf"') DO (
    set key=%%A
    IF "!key:~0,23!"=="wrapper.java.classpath." (
        set value=%%B
        IF "!value:~-2!" neq "/*" (
            set XL_SATELLITE_SERVER_CLASSPATH=!XL_SATELLITE_SERVER_CLASSPATH!;%%B
        ) ELSE (
            set XL_SATELLITE_SERVER_CLASSPATH=!XL_SATELLITE_SERVER_CLASSPATH!;%%B
            for /d %%i in ("%%B") do set XL_SATELLITE_SERVER_CLASSPATH=!XL_SATELLITE_SERVER_CLASSPATH!;!value:~0,-1!%%i
        )
    )
    IF "!key:~0,24!"=="wrapper.java.additional." (
        set XL_SATELLITE_SERVER_OPTS=!XL_SATELLITE_SERVER_OPTS! %%B
    )
)

REM Run XL Satellite server
:startSatellite
%JAVACMD% %XL_SATELLITE_SERVER_OPTS% -cp "%XL_SATELLITE_SERVER_CLASSPATH%" com.xebialabs.satellite.SatelliteBootstrapper %*
IF %errorlevel% EQU 242 (
    ECHO Restarting XL-Satellite
    GOTO startSatellite
)
endlocal
