#!/bin/sh
#
# Shell script to install XL Satellite Server as a daemon
#

DIR=$( cd "$( dirname "$0" )" && pwd )
. "$DIR"/.wrapper-env.sh

if [ ! -f "conf/satellite.conf" ]; then
    echo "The XL Satellite server is not initialized. Please execute the run.sh script!"
    exit 1
fi

read -p "Please provide the user that will run XL Satellite Server: " user
export user

# install daemon/ service
"$java_exe" "$wrapper_java_options" "$wrapper_logging_file_options" "$wrapper_java_sys_options" -jar "$wrapper_jar" -i "$conf_file"
"$java_exe" "$wrapper_java_options" "$wrapper_logging_file_options" "$wrapper_java_sys_options" -jar "$wrapper_jar" -t "$conf_file"