#!/bin/sh
#
# Commons for service wrapper related scripts
#

if [ "$(id -u)" != "0" ]; then
   echo "This script must be run as root" 1>&2
   exit 1
fi

absdirname () {
  _dir="`dirname \"$1\"`"
  cd "$_dir"
  echo "`pwd`"
}

resolvelink() {
  _dir=`dirname "$1"`
  _dest=`readlink "$1"`
  case "$_dest" in
  /* ) echo "$_dest" ;;
  *  ) echo "$_dir/$_dest" ;;
  esac
}

# Get XL Satellite server home dir
if [ -z "$xl_satellite_home" ] ; then
  self="$0"
  if [ -h "$self" ]; then
    self=`resolvelink "$self"`
  fi
  BIN_DIR=`absdirname "$self"`
  xl_satellite_home=`dirname "$BIN_DIR"`
elif [ ! -d "$xl_satellite_home" ] ; then
  echo "Directory $xl_satellite_home does not exist"
  exit 1
fi
export xl_satellite_home

cd "$xl_satellite_home"

# path to wrapper home
wrapper_home="$xl_satellite_home"/serviceWrapper
export wrapper_home

wrapper_jar="$wrapper_home"/wrapper.jar
export wrapper_jar

wrapper_java_sys_options=-Djna_tmpdir="$wrapper_home"/tmp
export wrapper_java_sys_options

wrapper_java_options="-Xmx30m"
export wrapper_java_options

wrapper_logging_file_options="-Djava.util.logging.config.file=$xl_satellite_home/conf/logging.properties"
export wrapper_logging_file_options

# Get Java executable
if [ -z "$JAVA_HOME" ] ; then
  java_exe=java
else
  java_exe="${JAVA_HOME}/bin/java"
fi
export java_exe

conf_file="$xl_satellite_home"/conf/xl-satellite-wrapper-linux.conf
export conf_file
