/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.satellite;

import ai.digital.deploy.task.serdes.TaskPekkoSerializer;
import ai.digital.deploy.task.serdes.TaskPekkoSerializer$;
import com.xebialabs.deployit.engine.tasker.RecoverySupervisorActor$;
import com.xebialabs.deployit.engine.tasker.TaskRecoveryListener$;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.satellite.PingActor;
import com.xebialabs.satellite.PluginManagementActor$;
import com.xebialabs.satellite.SatelliteConfig;
import com.xebialabs.satellite.SatelliteControlActor$;
import com.xebialabs.satellite.SatelliteInfoActor;
import com.xebialabs.satellite.SatelliteReconnectActor;
import com.xebialabs.satellite.SatelliteReconnectActor$;
import com.xebialabs.satellite.StreamingServer;
import com.xebialabs.satellite.StreamingServer$;
import com.xebialabs.satellite.StreamingServer$CheckStreamingServerConnection$;
import com.xebialabs.satellite.TaskSupervisor$;
import com.xebialabs.satellite.engine.EngineSupervisor$;
import com.xebialabs.satellite.engine.SatelliteSystem$;
import com.xebialabs.satellite.protocol.Paths$;
import com.xebialabs.xlplatform.pekko.Pekko$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.pattern.AskableActorSelection$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.mutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\f\u0018\u0001yA\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\t_\u0001\u0011\t\u0011)A\u0005O!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00033\u0011\u00159\u0004\u0001\"\u00019\u0011\u001da\u0004A1A\u0005\u0002uBa\u0001\u0013\u0001!\u0002\u0013q\u0004bB%\u0001\u0005\u0004%\tA\u0013\u0005\u0007'\u0002\u0001\u000b\u0011B&\t\u000fQ\u0003!\u0019!C\u0001+\"1\u0011\f\u0001Q\u0001\nYCqA\u0017\u0001C\u0002\u0013\u0005Q\u000b\u0003\u0004\\\u0001\u0001\u0006IA\u0016\u0005\b9\u0002\u0001\r\u0011\"\u0001>\u0011\u001di\u0006\u00011A\u0005\u0002yCa\u0001\u001a\u0001!B\u0013q\u0004\"B3\u0001\t\u00131\u0007\"B4\u0001\t\u0013A\u0007\"B9\u0001\t\u0013\u0011\bbBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003w\u0001A\u0011AA\u001f\u0005=\u0019\u0016\r^3mY&$XmU3sm\u0016\u0014(B\u0001\r\u001a\u0003%\u0019\u0018\r^3mY&$XM\u0003\u0002\u001b7\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\r1|wmZ3s+\u00059\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0013aA8sO&\u0011a&\u000b\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005y1/\u0019;fY2LG/Z\"p]\u001aLw-F\u00013!\t\u0019D'D\u0001\u0018\u0013\t)tCA\bTCR,G\u000e\\5uK\u000e{gNZ5h\u0003A\u0019\u0018\r^3mY&$XmQ8oM&<\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004siZ\u0004CA\u001a\u0001\u0011\u0015)S\u00011\u0001(\u0011\u0015\u0001T\u00011\u00013\u00031)gnZ5oKNK8\u000f^3n+\u0005q\u0004CA G\u001b\u0005\u0001%BA!C\u0003\u0015\t7\r^8s\u0015\t\u0019E)A\u0003qK.\\wN\u0003\u0002FW\u00051\u0011\r]1dQ\u0016L!a\u0012!\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\u000eK:<\u0017N\\3TsN$X-\u001c\u0011\u0002\u0017I,7m\u001c<fef$\u0015N]\u000b\u0002\u0017B\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\u0003S>T\u0011\u0001U\u0001\u0005U\u00064\u0018-\u0003\u0002S\u001b\n!a)\u001b7f\u00031\u0011XmY8wKJLH)\u001b:!\u0003I\u0011XmY8wKJL8+\u001e9feZL7o\u001c:\u0016\u0003Y\u0003\"aP,\n\u0005a\u0003%\u0001C!di>\u0014(+\u001a4\u0002'I,7m\u001c<fef\u001cV\u000f]3sm&\u001cxN\u001d\u0011\u0002!\u0015tw-\u001b8f'V\u0004XM\u001d<jg>\u0014\u0018!E3oO&tWmU;qKJ4\u0018n]8sA\u0005\u00192m\\7nk:L7-\u0019;j_:\u001c\u0016p\u001d;f[\u000692m\\7nk:L7-\u0019;j_:\u001c\u0016p\u001d;f[~#S-\u001d\u000b\u0003?\n\u0004\"\u0001\t1\n\u0005\u0005\f#\u0001B+oSRDqaY\b\u0002\u0002\u0003\u0007a(A\u0002yIE\nAcY8n[Vt\u0017nY1uS>t7+_:uK6\u0004\u0013!E3oO&tW-Q2u_J\u001c\u0016p\u001d;f[R\ta(\u0001\tuKJl\u0017N\\1u_J$\u0006N]3bIR\u0011\u0011n\u001c\t\u0003U6l\u0011a\u001b\u0006\u0003Y>\u000bA\u0001\\1oO&\u0011an\u001b\u0002\u0007)\"\u0014X-\u00193\t\u000bA\u0014\u0002\u0019\u0001 \u0002\rML8\u000f^3n\u0003a\u0019w.\\7v]&\u001c\u0017\r^5p]\u0006\u001bGo\u001c:TsN$X-\u001c\u000b\u0003}MDQ\u0001^\nA\u0002U\fqbY8o]\u0016\u001cG/[8o'R\fG/\u001a\t\u0004m\u0006\u0015abA<\u0002\u00029\u0011\u0001p \b\u0003szt!A_?\u000e\u0003mT!\u0001`\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0012B\u0001\u000e\u001c\u0013\tA\u0012$C\u0002\u0002\u0004]\tqcU1uK2d\u0017\u000e^3SK\u000e|gN\\3di\u0006\u001bGo\u001c:\n\t\u0005\u001d\u0011\u0011\u0002\u0002\u0010\u0007>tg.Z2uS>t7\u000b^1uK*\u0019\u00111A\f\u0002-]\f\u0017\u000e\u001e$peN#(/Z1nS:<7+\u001a:wKJ$\"!a\u0004\u0015\t\u0005E\u00111\u0006\t\u0007\u0003'\tI\"!\b\u000e\u0005\u0005U!bAA\fC\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005m\u0011Q\u0003\u0002\u0007\rV$XO]3\u0011\t\u0005}\u0011Q\u0005\b\u0004o\u0006\u0005\u0012bAA\u0012/\u0005y1\u000b\u001e:fC6LgnZ*feZ,'/\u0003\u0003\u0002(\u0005%\"\u0001G*ue\u0016\fW.\u001b8h'\u0016\u0014h/\u001a:D_:tWm\u0019;fI*\u0019\u00111E\f\t\u000f\u00055B\u0003q\u0001\u00020\u00059A/[7f_V$\b\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005U\")\u0001\u0003vi&d\u0017\u0002BA\u001d\u0003g\u0011q\u0001V5nK>,H/A\u0010sKN$\u0018M\u001d;D_6lWO\\5dCRLwN\\!di>\u00148+_:uK6$2aXA \u0011\u0015!X\u00031\u0001v\u0001")
public class SatelliteServer {
    private final Logger logger;
    private final SatelliteConfig satelliteConfig;
    private final ActorSystem engineSystem;
    private final File recoveryDir;
    private final ActorRef recoverySupervisor;
    private final ActorRef engineSupervisor;
    private ActorSystem communicationSystem;

    public Logger logger() {
        return this.logger;
    }

    public SatelliteConfig satelliteConfig() {
        return this.satelliteConfig;
    }

    public ActorSystem engineSystem() {
        return this.engineSystem;
    }

    public File recoveryDir() {
        return this.recoveryDir;
    }

    public ActorRef recoverySupervisor() {
        return this.recoverySupervisor;
    }

    public ActorRef engineSupervisor() {
        return this.engineSupervisor;
    }

    public ActorSystem communicationSystem() {
        return this.communicationSystem;
    }

    public void communicationSystem_$eq(ActorSystem x$1) {
        this.communicationSystem = x$1;
    }

    private ActorSystem engineActorSystem() {
        ActorSystem system = ActorSystem$.MODULE$.apply(com.xebialabs.deployit.engine.tasker.satellite.Paths$.MODULE$.systemName() + "-tasks", this.satelliteConfig().tasksSystem());
        this.logger().info("Starting " + system);
        Runtime.getRuntime().addShutdownHook(this.terminatorThread(system));
        system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> this.logger().info("XL Satellite has shutdown"));
        return system;
    }

    private Thread terminatorThread(ActorSystem system) {
        Thread t = new Thread(() -> {
            this.logger().info("XL Satellite is shutting down");
            Pekko$.MODULE$.terminate(system, Pekko$.MODULE$.terminate$default$2());
        }, "actorsystem-terminator");
        t.setUncaughtExceptionHandler((x$1, cause) -> this.logger().error("Encountered exception while shutting down XL Satellite", cause));
        t.setDaemon(false);
        t.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        return t;
    }

    public ActorSystem com$xebialabs$satellite$SatelliteServer$$communicationActorSystem(Map<Address, SatelliteReconnectActor.ConnectStatus> connectionState) {
        ActorSystem system = SatelliteSystem$.MODULE$.newActorSystem(this.satelliteConfig().communicationSystem(), SatelliteSystem$.MODULE$.newActorSystem$default$2());
        TaskPekkoSerializer qual$1 = TaskPekkoSerializer$.MODULE$.taskPekkoSerializer(system, WorkDir.class);
        TaskPekkoSerializer.Conf x$1 = new TaskPekkoSerializer.Conf(new File(this.satelliteConfig().workdir()));
        boolean x$2 = qual$1.initExternalWorker$default$2();
        qual$1.initExternalWorker(x$1, x$2);
        system.actorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(PingActor.class)), Paths$.MODULE$.ping().name());
        system.actorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(SatelliteInfoActor.class)), Paths$.MODULE$.info().name());
        system.actorOf(PluginManagementActor$.MODULE$.props(), PluginManagementActor$.MODULE$.name());
        String string = this.satelliteConfig().streamingConnectionResolver();
        String string2 = "blocking";
        ActorRef streamingServer = system.actorOf(!(string != null ? !string.equals(string2) : string2 != null) ? StreamingServer$.MODULE$.propsForBlocking(StreamingServer$.MODULE$.propsForBlocking$default$1()) : StreamingServer$.MODULE$.propsForPort(StreamingServer$.MODULE$.propsForPort$default$1()), StreamingServer$.MODULE$.name());
        this.logger().debug("StreamingServer: " + streamingServer);
        ActorRef taskSupervisor = system.actorOf(TaskSupervisor$.MODULE$.props(streamingServer, (ExtendedActorSystem)system, this.engineSupervisor()), TaskSupervisor$.MODULE$.name());
        system.actorOf(SatelliteControlActor$.MODULE$.props(taskSupervisor, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> SatelliteControlActor$.MODULE$.props$default$2()), SatelliteControlActor$.MODULE$.name());
        system.actorOf(SatelliteReconnectActor$.MODULE$.props(this, connectionState), SatelliteReconnectActor$.MODULE$.name());
        return system;
    }

    public Future<StreamingServer.StreamingServerConnected> waitForStreamingServer(Timeout timeout) {
        ActorSelection qual$1 = package$.MODULE$.ask(this.communicationSystem().actorSelection(this.communicationSystem().$div(StreamingServer$.MODULE$.name())));
        StreamingServer$CheckStreamingServerConnection$ x$1 = StreamingServer$CheckStreamingServerConnection$.MODULE$;
        Timeout x$2 = timeout;
        ActorRef x$3 = AskableActorSelection$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorSelection$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(StreamingServer.StreamingServerConnected.class));
    }

    public void restartCommunicationActorSystem(Map<Address, SatelliteReconnectActor.ConnectStatus> connectionState) {
        ExecutionContextExecutor ec = this.communicationSystem().dispatcher();
        this.communicationSystem().terminate().andThen((PartialFunction)new Serializable(this, connectionState){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SatelliteServer $outer;
            private final Map connectionState$1;

            public final <A1 extends Try<Terminated>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().info("Restarting communication system");
                this.$outer.communicationSystem_$eq(this.$outer.com$xebialabs$satellite$SatelliteServer$$communicationActorSystem((Map<Address, SatelliteReconnectActor.ConnectStatus>)this.connectionState$1));
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Try<Terminated> x1) {
                Try<Terminated> try_ = x1;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.connectionState$1 = connectionState$1;
            }
        }, (ExecutionContext)ec);
    }

    public SatelliteServer(Logger logger, SatelliteConfig satelliteConfig) {
        this.logger = logger;
        this.satelliteConfig = satelliteConfig;
        this.engineSystem = this.engineActorSystem();
        this.recoveryDir = Paths.get(satelliteConfig.recoveryDir(), new String[0]).toFile();
        this.recoverySupervisor = this.engineSystem().actorOf(RecoverySupervisorActor$.MODULE$.props(this.recoveryDir()), RecoverySupervisorActor$.MODULE$.name());
        this.engineSystem().actorOf(TaskRecoveryListener$.MODULE$.props(this.recoverySupervisor()), TaskRecoveryListener$.MODULE$.name());
        this.engineSupervisor = this.engineSystem().actorOf(EngineSupervisor$.MODULE$.props(this.recoverySupervisor()), EngineSupervisor$.MODULE$.name());
        this.communicationSystem = this.com$xebialabs$satellite$SatelliteServer$$communicationActorSystem(SatelliteReconnectActor$.MODULE$.emptyConnectionState());
    }
}

