package com.xebialabs.satellite

import com.xebialabs.deployit.engine.api.execution.BlockExecutionState
import com.xebialabs.deployit.engine.tasker._
import grizzled.slf4j.Logging

package object engine {

  implicit class BlocksUtils(blocks: Seq[Block]) extends Logging {

    def hasAllBlocksPassive: Boolean = {
      val states = blocks.map(_.getState())
      debug(s"hasAllBlocksPassive: $states")
      states.forall(state => !activeBlockStates.contains(state))
    }

    private val activeBlockStates = Seq(BlockExecutionState.ABORTING, BlockExecutionState.EXECUTING, BlockExecutionState.STOPPING, BlockExecutionState.FAILING)
  }
}
