package com.xebialabs.satellite.engine


import com.typesafe.config._
import com.typesafe.config.ConfigFactory._
import com.xebialabs.deployit.engine.tasker.satellite.Paths
import com.xebialabs.xlplatform.settings.ConfigSupport
import grizzled.slf4j.Logging

import java.util.Collections.singletonMap
import com.xebialabs.deployit.security.SecretKeyHolder
import com.xebialabs.xlplatform.config.ConfigLoader
import org.apache.pekko.actor.ActorSystem

object SatelliteSystem extends Logging with ConfigSupport {
  val SatelliteHost: String = "deploy.server.hostname"
  val SatellitePort: String = "deploy.server.port"

  def newActorSystem(config: Config, systemName: String = Paths.systemName) = {
    ActorSystem.create(systemName, config)
  }

  def configuration(
                     baseConfig: Config = ConfigLoader.loadSecuredWithDynamic(
                       "satellite.conf",
                       SecretKeyHolder.get(),
                       defaultReference = ConfigFactory.empty()
                     )
                   ) =
    loadWithFallbacks(
      baseConfig,
      hostAddressConfiguration(SatelliteHost),
      enabledTransports(baseConfig),
      parseResources("satellite-reference.conf")
    )

  def enabledTransports(baseConfig: Config): Config = {
    val sslEnabled = baseConfig.hasPath("deploy.server.ssl.enabled") && baseConfig.getBoolean("deploy.server.ssl.enabled")
    parseMap(singletonMap("pekko.remote.artery.transport", if (sslEnabled) "tls-tcp" else "tcp"))
  }
}
