package com.xebialabs.satellite.engine

import com.xebialabs.satellite.engine.BlockExecutionEngine.CurrentBlockState
import org.apache.pekko.actor.{ActorRef, Stash, Terminated}
import org.apache.pekko.event.LoggingReceive

trait HandleCurrentBlockState { actor: Stash =>

  type WhenDone = Seq[CurrentBlockState] => Unit
  type ExcludeOnTerminate = (CurrentBlockState, ActorRef) => Boolean

  def waitForBlockStatusesOrFinish(receivedMessages: Seq[CurrentBlockState] = Nil, expectedResponses: Int, behaviourChanges: Int = 0)
                                  (implicit whenDone: WhenDone, excludeOnTerminate: ExcludeOnTerminate): Unit = {
    receivedMessages.length match {
      case `expectedResponses` =>
        whenDone(receivedMessages)
        1 to behaviourChanges foreach (_ => context.unbecome())
        unstashAll()
      case _ =>
        context.become(waitForBlockStatuses(receivedMessages, expectedResponses, behaviourChanges + 1), discardOld = false)
    }
  }

  def waitForBlockStatuses(receivedMessages: Seq[CurrentBlockState], expectedResponses: Int, behaviourChanges: Int)
                          (implicit whenDone: WhenDone, excludeOnTerminate: ExcludeOnTerminate): Receive = LoggingReceive {
    case msg: CurrentBlockState =>
      waitForBlockStatusesOrFinish(msg +: receivedMessages, expectedResponses, behaviourChanges)
    case Terminated(child) =>
      waitForBlockStatusesOrFinish(receivedMessages.filterNot(msg => excludeOnTerminate(msg, child)), expectedResponses - 1, behaviourChanges)
    case _ =>
      stash()
  }
}
