package com.xebialabs.deployit.plugin.satellite

import java.net.URI

import akka.actor.ActorSystem
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext
import com.xebialabs.deployit.plugin.satellite.extension.ExtensionsLocator

case class InstalledExtensionsDelta(plugins: Set[URI], pluginHotfix: Set[URI], satelliteHotfix: Set[URI], ext: Set[URI]) {
  val empty = List(plugins, pluginHotfix, satelliteHotfix, ext).forall(_.isEmpty)
}

trait SatellitePluginsSugar {

  def actorLocator: ActorLocator

  def calculateExtensionsDelta(extensionsLocator: ExtensionsLocator, ctx: ExecutionContext)(implicit satelliteCommunicatorSystem: ActorSystem): InstalledExtensionsDelta =
    ExtensionsDelta.calculateExtensionsDelta(extensionsLocator, actorLocator)
}
