package com.xebialabs.deployit.plugin.satellite

import akka.actor._
import com.xebialabs.deployit.plugin.satellite.UploadTaskSupervisor.Protocol.UploadFilesTask

class StreamingSupervisor extends Actor {
  def receive: Receive = {
    case task: UploadFilesTask =>
      val taskSupervisor = UploadTaskSupervisor.props(sender(), task)
      val config = task.config
      context.actorOf(taskSupervisor, s"upload-supervisor-${config.taskId}-${config.satelliteAddress.hostname}:${config.satelliteAddress.protocolPort}")
  }
}

object StreamingSupervisor {
  def props(): Props = Props[StreamingSupervisor]
}