package com.xebialabs.deployit.plugin.satellite

import java.io.{InputStream, File}

import com.xebialabs.deployit.io.ArtifactFile
import com.xebialabs.overthere.OverthereFile
import com.xebialabs.overthere.local.LocalFile

class PluginLocalFile(file: File) extends ArtifactFile {

  override def getRawStream: InputStream = getInputStream

  override protected def getLazyFile: OverthereFile = LocalFile.from(file)

  override def isResolvable: Boolean = true

  override def isResolved: Boolean = true
}

object PluginLocalFile {
  def apply(file:File) = new PluginLocalFile(file)
}


