package com.xebialabs.deployit.plugin.satellite.ci;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import akka.actor.ActorRef;
import com.google.common.collect.Lists;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.satellite.*;
import com.xebialabs.xlplatform.satellite.Satellite;

import akka.actor.ActorSystem;

public class SatelliteTasks {

    public SatelliteTasks() {
    }

    @Delegate(name = "pingSatellite")
    public static List<Step> ping(Satellite ci, String method, Map<String, String> arguments) {
        return Lists.newArrayList((Step) PingSatelliteStep.apply(ci, SatelliteCommunicatorSystem.actorSystem()));
    }

    @Delegate(name = "syncPlugins")
    public static List<Step> sync(final Satellite ci, String method, Map<String, String> arguments, Parameters parameters) {

        final ActorSystem satelliteCommunicatorSystem = SatelliteCommunicatorSystem.actorSystem();
        final ActorRef uploader = SatelliteCommunicatorSystem.uploader();
        return Arrays.<Step>asList(
                SyncExtensionsStep.apply(ci, satelliteCommunicatorSystem, uploader),
//                CleanUpSatelliteStep.apply(ci, satelliteCommunicatorSystem),
                RestartSatelliteStep.apply(ci, satelliteCommunicatorSystem),
                WaitingForRestartStep.apply(
                        ci,
                        parameters.getProperty("maxAttempts"),
                        parameters.getProperty("delay"),
                        satelliteCommunicatorSystem
                )
        );
    }


}
