package com.xebialabs.deployit.plugin.satellite

import akka.actor._
import com.xebialabs.deployit.engine.tasker.TaskId
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext
import com.xebialabs.deployit.plugin.satellite.StreamingSupervisor.UploadRequest
import com.xebialabs.overthere.OverthereFile
import com.xebialabs.satellite.protocol.UploadId
import com.xebialabs.satellite.serialization.ArtifactId

class StreamingSupervisor extends Actor {

  val log = akka.event.Logging(context.system, classOf[StreamingSupervisor])

  def receive: Receive = {
    case request: UploadRequest =>
      val fileUploadProps: Props = FileUploader.props(sender(), request)
      context.actorOf(fileUploadProps, request.id.toString) forward request
  }

}

object StreamingSupervisor {
  def props(): Props = Props[StreamingSupervisor]

  case class UploadRequest(taskId: TaskId,
                           artifactId: ArtifactId,
                           overthereFile: OverthereFile,
                           ctx: ExecutionContext,
                           satellite: ActorLocator,
                           satelliteHostname: String,
                           id: UploadId = UploadId())

  object UploadRequest {
    val ENCRYPTED = true
    val PLAIN = false
  }

}

