package com.xebialabs.deployit.plugin.satellite

import java.io.File
import java.net.URI

import akka.actor.ActorSystem
import akka.pattern._
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext
import com.xebialabs.satellite.protocol.{Paths, GetInstalledPlugins, InstalledPlugins}
import com.xebialabs.xlplatform.settings.CommonSettings

import scala.concurrent.Await

trait SatellitePluginsSugar {

  def actorLocator:ActorLocator

  def allPlugins:Set[URI]

  def askSatellitePlugin(ctx: ExecutionContext)(implicit satelliteCommunicatorSystem: ActorSystem) : Set[URI] = {
    implicit val timeout = CommonSettings(satelliteCommunicatorSystem).satellite.pingTimeout

    val satellitePluginManagement = actorLocator.locate(Paths.pluginManagement)

    val satelliteInstall = Await.result((satellitePluginManagement ? GetInstalledPlugins).mapTo[InstalledPlugins], atMost = timeout.duration)

    ctx.logOutput(s"Found following plugins on the satellite : ${satelliteInstall.plugins.size}")
    satelliteInstall.plugins.foreach(ctx.logOutput)

    ctx.logOutput(s"Found following plugins on XL-Deploy : ${allPlugins.size}")
    allPlugins.foreach(plugin => ctx.logOutput(plugin.toString))

    allPlugins.filterNot(plugin => satelliteInstall.plugins.contains(new File(plugin).getName))
  }
}
