package com.xebialabs.deployit.plugin.satellite

import akka.actor._
import com.typesafe.config.Config
import com.typesafe.config.ConfigFactory.parseResources
import com.xebialabs.xlplatform.settings.{CommonSettings, ConfigSupport, SatelliteSettings}

import scala.concurrent.ExecutionContext

object SatelliteCommunicatorSystem extends ConfigSupport {

  lazy val actorSystem: ActorSystem = newActorSystem(parseResources("system.conf"))

  def newActorSystem(systemConfig: Config, systemName: Option[String] = None): ActorSystem = {
    val satelliteEnabled = new SatelliteSettings(systemConfig).enabled
    val (fallbacks, defaultName) = if(satelliteEnabled) {
      (Seq(hostAddressConfiguration("satellite.hostname"), parseResources("system-reference-satellite-enabled.conf")), "SatelliteTaskSystem")
    } else {
      (Seq(parseResources("system-reference-satellite-disabled.conf")), "TaskSystem")
    }
    ActorSystem.create(systemName.getOrElse(defaultName), loadWithFallbacks(systemConfig, fallbacks:_*))
  }

  lazy val uploaderPath = uploader.path

  lazy val uploader = actorSystem.actorOf(StreamingSupervisor.props(), "uploader")

  lazy val config = CommonSettings(actorSystem).satellite

  implicit lazy val dispatcher: ExecutionContext = actorSystem.dispatcher
}
