package com.xebialabs.deployit.plugin.satellite

import akka.actor._
import com.typesafe.config.Config
import com.typesafe.config.ConfigFactory.{empty, parseMap, parseResources}
import com.xebialabs.xlplatform.settings.{CommonSettings, ConfigSupport, SatelliteSettings}

import scala.concurrent.ExecutionContext

object SatelliteCommunicatorSystem extends ConfigSupport {

  lazy val actorSystem: ActorSystem = newActorSystem(parseResources("system.conf"))

  def newActorSystem(systemConfig: Config, systemName: Option[String] = None): ActorSystem = {
    val satellite = new SatelliteSettings(systemConfig)
    val (fallbacks, defaultName) = if (satellite.enabled) {
      (Seq(hostAddressConfiguration("satellite.hostname"), sslRemoteTransports(satellite), parseResources("system-reference-satellite-enabled.conf")), "SatelliteTaskSystem")
    } else {
      (Seq(parseResources("system-reference-satellite-disabled.conf")), "TaskSystem")
    }
    ActorSystem.create(systemName.getOrElse(defaultName), loadWithFallbacks(systemConfig, fallbacks: _*))
  }

  private[this] def sslRemoteTransports(satellite: SatelliteSettings): Config = {
    import scala.collection.JavaConverters._
    import scala.collection.convert.wrapAsJava._
    if (satellite.sslEnabled) {
      parseMap(Map("satellite.remote.enabled-transports" -> Seq("akka.remote.netty.ssl").asJava))
    } else {
      empty()
    }
  }

  lazy val uploaderPath = uploader.path

  lazy val uploader = actorSystem.actorOf(StreamingSupervisor.props(), "uploader")

  lazy val config = CommonSettings(actorSystem).satellite

  implicit lazy val dispatcher: ExecutionContext = actorSystem.dispatcher
}
