package com.xebialabs.deployit.plugin.satellite

import java.net.InetAddress

import akka.actor._
import com.typesafe.config.ConfigFactory.parseResources
import com.typesafe.config.{Config, ConfigFactory}
import com.xebialabs.xlplatform.settings.CommonSettings

import scala.concurrent.ExecutionContext
import collection.convert.wrapAsJava._
import scala.util.Try

object SatelliteCommunicatorSystem {

  lazy val actorSystem: ActorSystem = newActorSystem()

  def newActorSystem(systemConfig: Config = parseResources("system.conf"), systemName: String = "Satellite-Communicator"): ActorSystem = {
    val configuration: Config = systemConfig.withFallback(hostAddressConfiguration.withFallback(parseResources("reference-system.conf")))
    ActorSystem.create(systemName, ConfigFactory.load(configuration))
  }

  private[this] def hostAddressConfiguration: Config = {
    val hostname: String = Try(InetAddress.getLocalHost.getHostAddress).getOrElse(InetAddress.getLoopbackAddress.getHostAddress)
    ConfigFactory.parseMap(Map("satellite.hostname" -> hostname))
  }

  lazy val uploaderPath = uploader.path

  lazy val uploader = actorSystem.actorOf(StreamingSupervisor.props(), "uploader")

  lazy val config = CommonSettings(actorSystem).satellite

  implicit lazy val dispatcher: ExecutionContext = actorSystem.dispatcher
}
