package com.xebialabs.deployit.plugin.satellite

import java.io.ObjectInputStream

import akka.actor.ActorSystem
import akka.pattern.ask
import com.xebialabs.deployit.engine.tasker
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator
import com.xebialabs.deployit.engine.tasker.{TaskExecutionContext, TaskSpecification}
import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Step, StepExitCode}
import com.xebialabs.satellite.future.AwaitForever
import com.xebialabs.satellite.protocol.CleanUpTask
import com.xebialabs.xlplatform.satellite.Satellite
import com.xebialabs.xlplatform.settings.CommonSettings

import scala.beans.BeanProperty

case class CleanUpSatelliteStep(actorLocator: ActorLocator, @BeanProperty description: String)
                               (implicit @transient var satelliteCommunicatorSystem: ActorSystem) extends Step with AwaitForever {

  @BeanProperty val order = Step.DEFAULT_ORDER

  override def execute(ctx: ExecutionContext): StepExitCode = {
    implicit val executionContext = satelliteCommunicatorSystem.dispatcher

    val task = ctx.getAttribute(TaskExecutionContext.CACHE_KEY).asInstanceOf[TaskSpecification]

    implicit val timeout = CommonSettings(satelliteCommunicatorSystem).satellite.pingTimeout

    val remoteTaskActor = actorLocator.locate(tasker.satellite.Paths.tasks)

    val complete = (remoteTaskActor ? CleanUpTask(task.getId)).map(_ => StepExitCode.SUCCESS).recover {
      case _ => StepExitCode.FAIL
    }

    blockOrThrow(complete)

  }

  private def readObject(in: ObjectInputStream): Unit = {
    in.defaultReadObject()
    satelliteCommunicatorSystem = SatelliteCommunicatorSystem.actorSystem
  }
}

object CleanUpSatelliteStep {
  def apply(satellite: Satellite)(implicit satelliteCommunicatorSystem: ActorSystem): CleanUpSatelliteStep = {
    new CleanUpSatelliteStep(ActorLocator(satellite), s"Cleaning up task file on satellite ${satellite.getName}")
  }
}
