package com.xebialabs.deployit.plugin.satellite

import java.io.{ObjectInputStream, File}
import java.net.URI

import akka.actor.ActorSystem
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator
import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Step, StepExitCode}
import com.xebialabs.satellite.future.AwaitForever
import com.xebialabs.xlplatform.satellite.Satellite

import scala.beans.BeanProperty

case class CheckPluginStep(actorLocator: ActorLocator, @BeanProperty description: String, allPlugins: Set[URI])
                          (implicit @transient var satelliteCommunicatorSystem: ActorSystem) extends Step with AwaitForever with SatellitePluginsSugar {

  @BeanProperty val order = Step.DEFAULT_ORDER

  override def execute(ctx: ExecutionContext): StepExitCode = {
    ctx.logOutput(s"Connecting to $actorLocator")

    val pluginsToUpload = askSatellitePlugin(ctx)

    if (pluginsToUpload.isEmpty) {
      ctx.logOutput(s"Satellite is up-to-date")
      StepExitCode.SUCCESS
    } else {
      ctx.logOutput(s"Found unsynchronized plugins")
      pluginsToUpload.foreach(plugin => ctx.logOutput(plugin.toURL.getFile))

      StepExitCode.FAIL
    }
  }

  private def readObject(in: ObjectInputStream): Unit = {
    in.defaultReadObject()
    satelliteCommunicatorSystem = SatelliteCommunicatorSystem.actorSystem
  }
}

object CheckPluginStep {
  def apply(satellite: Satellite)(implicit satelliteCommunicatorSystem: ActorSystem) : CheckPluginStep = {
    new CheckPluginStep(
      ActorLocator(satellite), "Checking plugins on satellite", findAllXlDPlugins(new File("plugins")))
  }

  def findAllXlDPlugins(directory: File) = {
    val listFiles = Option(directory.listFiles())
    listFiles match {
      case Some(files) => files.filterNot(_.getName.endsWith("txt")).map(_.toURI).toSet
      case _ => Set.empty[URI]
    }
  }
}
