package com.xebialabs.deployit.plugin.satellite

import java.io.File
import java.net.URI

import akka.pattern._
import com.xebialabs.deployit.engine.tasker.satellite.SatellitePath
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext
import com.xebialabs.satellite.protocol.{Paths, GetInstalledPlugins, InstalledPlugins}

import scala.concurrent.Await

trait SatellitePluginsSugar {

  def satellitePath:SatellitePath

  def allPlugins:Set[URI]

  def askSatellitePlugin(ctx: ExecutionContext): Set[URI] = {
    implicit val actorSystem = SatelliteActorSystem.actorSystem
    implicit val timeout = SatelliteActorSystem.config.pingTimeout

    val satellitePluginManagement = satellitePath.locate(Paths.pluginManagement)

    val satelliteInstall = Await.result((satellitePluginManagement ? GetInstalledPlugins).mapTo[InstalledPlugins], atMost = SatelliteActorSystem.config.pingTimeout.duration)

    ctx.logOutput(s"Found following plugins on the satellite : ${satelliteInstall.plugins.size}")
    satelliteInstall.plugins.foreach(ctx.logOutput)

    ctx.logOutput(s"Found following plugins on XL-Deploy : ${allPlugins.size}")
    allPlugins.foreach(plugin => ctx.logOutput(plugin.toString))

    allPlugins.filterNot(plugin => satelliteInstall.plugins.contains(new File(plugin).getName))
  }
}
