package com.xebialabs.deployit.plugin.satellite

import akka.util.Timeout
import akka.pattern.ask
import com.xebialabs.deployit.engine.tasker.satellite.SatellitePath
import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Step, StepExitCode}
import com.xebialabs.satellite.protocol.Paths
import com.xebialabs.xlplatform.satellite.Satellite

import scala.beans.BeanProperty
import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{Await, Future}

case class PingSatelliteStep(satellitePath: SatellitePath, @BeanProperty description: String, clock: Clock = Clock()) extends Step {

  def getOrder: Int = Step.DEFAULT_ORDER

  def execute(ctx: ExecutionContext): StepExitCode = {
    implicit val system = SatelliteActorSystem.actorSystem
    import system.dispatcher
    val pingTimeout = SatelliteActorSystem.config.pingTimeout.duration

    implicit val timeout: Timeout = Timeout((pingTimeout * 1.5).asInstanceOf[FiniteDuration])

    ctx.logOutput(s"Connecting to $satellitePath")

    val pinger = SatelliteActorSystem.actorSystem.actorOf(Pinger.props(ctx, pingTimeout, clock))

    val exitCode: Future[StepExitCode] = (pinger ? Pinger.Start(satellitePath.locate(Paths.ping)))
      .mapTo[StepExitCode]
      .recover { case _ =>
      ctx.logError(s"Operation timeout ($pingTimeout)")
      StepExitCode.FAIL
    }

    Await.result(exitCode, timeout.duration)
  }

}

object PingSatelliteStep {

  def apply(satellite: Satellite): PingSatelliteStep = new PingSatelliteStep(SatellitePath(satellite), s"Checking connectivity with satellite ${satellite.getName}")
}