package com.xebialabs.deployit.plugin.satellite

import java.io.File
import java.net.URI

import com.xebialabs.deployit.engine.tasker.satellite.SatellitePath
import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Step, StepExitCode}
import com.xebialabs.satellite.future.AwaitForever
import com.xebialabs.xlplatform.satellite.Satellite

import scala.beans.BeanProperty

case class CheckPluginStep(satellitePath: SatellitePath, @BeanProperty description: String, allPlugins: Set[URI]) extends Step with AwaitForever with SatellitePluginsSugar {

  override def execute(ctx: ExecutionContext): StepExitCode = {
    ctx.logOutput(s"Connecting to $satellitePath")

    val pluginsToUpload = askSatellitePlugin(ctx)

    if (pluginsToUpload.isEmpty) {
      ctx.logOutput(s"Satellite is up-to-date")
      StepExitCode.SUCCESS
    } else {
      ctx.logOutput(s"Found unsynchronized plugins")
      pluginsToUpload.foreach(plugin => ctx.logOutput(plugin.toURL.getFile))

      StepExitCode.FAIL
    }
  }

  @BeanProperty val order = Step.DEFAULT_ORDER

}

object CheckPluginStep {
  def apply(satellite: Satellite): CheckPluginStep = {
    new CheckPluginStep(
      SatellitePath(satellite), "Checking plugins on satellite", findAllXlDPlugins(new File("plugins")))
  }

  def findAllXlDPlugins(directory: File) = {
    val listFiles = Option(directory.listFiles())
    listFiles match {
      case Some(files) => files.filterNot(_.getName.endsWith("txt")).map(_.toURI).toSet
      case _ => Set.empty[URI]
    }
  }
}
