package com.xebialabs.deployit.plugin.satellite

import java.net.InetAddress

import akka.actor._
import com.typesafe.config.ConfigFactory
import com.xebialabs.xlplatform.settings.CommonSettings

import scala.concurrent.ExecutionContext

object SatelliteActorSystem {

  var actorSystem: ActorSystem = newActorSystem

  def scheduler = actorSystem.scheduler

  private[satellite] def restart(): Unit = {
    actorSystem.shutdown()
    actorSystem.awaitTermination()
    actorSystem = newActorSystem
  }

  private def newActorSystem: ActorSystem = {
    def defaultConfiguration = ConfigFactory.load("satellite.conf")

    if (!defaultConfiguration.hasPath("akka.remote.netty.tcp.hostname")) {
      System.setProperty("akka.remote.netty.tcp.hostname", InetAddress.getLocalHost.getHostName)
    }

    println("Creating XL-Satellite-plugin actor system")
    ActorSystem.create("XL-Satellite-plugin", defaultConfiguration)
  }

  lazy val uploaderPath = uploader.path

  lazy val uploader = actorSystem.actorOf(StreamingSupervisor.props(), "uploader")

  lazy val config = CommonSettings(actorSystem).satellite

  implicit lazy val dispatcher: ExecutionContext = actorSystem.dispatcher
}