package com.xebialabs.deployit.plugin.satellite

import akka.pattern.ask
import com.xebialabs.deployit.engine.tasker
import com.xebialabs.deployit.engine.tasker.satellite.SatellitePath
import com.xebialabs.deployit.engine.tasker.{TaskExecutionContext, TaskSpecification}
import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Step, StepExitCode}
import com.xebialabs.satellite.future.AwaitForever
import com.xebialabs.satellite.protocol.CleanUpTask
import com.xebialabs.xlplatform.satellite.Satellite

import scala.beans.BeanProperty

case class CleanUpSatelliteStep(satellitePath: SatellitePath, @BeanProperty description: String) extends Step with AwaitForever {

  @BeanProperty val order = Step.DEFAULT_ORDER

  override def execute(ctx: ExecutionContext): StepExitCode = {
    implicit val executionContext = SatelliteActorSystem.actorSystem.dispatcher

    val task = ctx.getAttribute(TaskExecutionContext.CACHE_KEY).asInstanceOf[TaskSpecification]

    implicit val timeout = SatelliteActorSystem.config.pingTimeout
    implicit val actorSystem = SatelliteActorSystem.actorSystem

    val remoteTaskActor = satellitePath.locate(tasker.satellite.Paths.tasks)

    val complete = (remoteTaskActor ? CleanUpTask(task.getId)).map(_=> StepExitCode.SUCCESS).recover {
      case _ => StepExitCode.FAIL
    }

    blockOrThrow(complete)

  }
}

object CleanUpSatelliteStep {
  def apply(satellite:Satellite):CleanUpSatelliteStep = new CleanUpSatelliteStep(SatellitePath(satellite), s"Cleaning up task file on satellite ${satellite.getName}")
}
