package com.xebialabs.satellite.streaming

import java.io.InputStream

import akka.stream.scaladsl.{StreamConverters, Source}
import akka.util.ByteString
import com.xebialabs.satellite.streaming.DigesterStage._
import grizzled.slf4j.Logging

import scala.concurrent.Future

object UploadStage extends Logging {

  def source(startOn: Future[Any], inputStream: InputStream)(digesterOnComplete: ProcessDigest)(implicit streamConfig: StreamConfig): Source[ByteString, _] = {
    Source.fromFuture(startOn)
      .flatMapConcat(_ => StreamConverters.fromInputStream(() => inputStream, streamConfig.chunkSize))
      .via(DigesterStage.flow(digesterOnComplete)).via(Compression.compress)
  }
}
