/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.satellite.streaming;

import akka.stream.scaladsl.Flow;
import akka.stream.stage.Context;
import akka.stream.stage.PushStage;
import akka.stream.stage.SyncDirective;
import akka.stream.stage.TerminationDirective;
import akka.util.ByteString;
import com.xebialabs.satellite.streaming.DigesterStage$;
import java.security.MessageDigest;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\u0015s!B\u0001\u0003\u0011\u0003Y\u0011!\u0004#jO\u0016\u001cH/\u001a:Ti\u0006<WM\u0003\u0002\u0004\t\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000b\u0019\t\u0011b]1uK2d\u0017\u000e^3\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!!\u0004#jO\u0016\u001cH/\u001a:Ti\u0006<Wm\u0005\u0002\u000e!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQaF\u0007\u0005\u0002a\ta\u0001P5oSRtD#A\u0006\u0006\tii\u0001a\u0007\u0002\u000e!J|7-Z:t\t&<Wm\u001d;\u0011\u000bEab$a\u0005\n\u0005u\u0011\"!\u0003$v]\u000e$\u0018n\u001c82!\ty\u0002%D\u0001\u000e\r\u0011\tS\u0002\u0011\u0012\u0003\r\u0011Kw-Z:u'\u0011\u0001\u0003c\t\u0014\u0011\u0005E!\u0013BA\u0013\u0013\u0005\u001d\u0001&o\u001c3vGR\u0004\"!E\u0014\n\u0005!\u0012\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0016!\u0005+\u0007I\u0011A\u0016\u0002\u0011\rDWmY6tk6,\u0012\u0001\f\t\u0003[Ar!!\u0005\u0018\n\u0005=\u0012\u0012A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!a\f\n\t\u0011Q\u0002#\u0011#Q\u0001\n1\n\u0011b\u00195fG.\u001cX/\u001c\u0011\t\u0011Y\u0002#Q3A\u0005\u0002]\nAa]5{KV\t\u0001\b\u0005\u0002\u0012s%\u0011!H\u0005\u0002\u0005\u0019>tw\r\u0003\u0005=A\tE\t\u0015!\u00039\u0003\u0015\u0019\u0018N_3!\u0011\u00159\u0002\u0005\"\u0001?)\rqr\b\u0011\u0005\u0006Uu\u0002\r\u0001\f\u0005\u0006mu\u0002\r\u0001\u000f\u0005\b\u0005\u0002\n\t\u0011\"\u0001D\u0003\u0011\u0019w\u000e]=\u0015\u0007y!U\tC\u0004+\u0003B\u0005\t\u0019\u0001\u0017\t\u000fY\n\u0005\u0013!a\u0001q!9q\tII\u0001\n\u0003A\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002\u0013*\u0012AFS\u0016\u0002\u0017B\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u0015\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002S\u001b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fQ\u0003\u0013\u0013!C\u0001+\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T#\u0001,+\u0005aR\u0005b\u0002-!\u0003\u0003%\t%W\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003i\u0003\"a\u00171\u000e\u0003qS!!\u00180\u0002\t1\fgn\u001a\u0006\u0002?\u0006!!.\u0019<b\u0013\t\tD\fC\u0004cA\u0005\u0005I\u0011A2\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003\u0011\u0004\"!E3\n\u0005\u0019\u0014\"aA%oi\"9\u0001\u000eIA\u0001\n\u0003I\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0003U6\u0004\"!E6\n\u00051\u0014\"aA!os\"9anZA\u0001\u0002\u0004!\u0017a\u0001=%c!9\u0001\u000fIA\u0001\n\u0003\n\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003I\u00042a\u001d<k\u001b\u0005!(BA;\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003oR\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\bs\u0002\n\t\u0011\"\u0001{\u0003!\u0019\u0017M\\#rk\u0006dGCA>\u007f!\t\tB0\u0003\u0002~%\t9!i\\8mK\u0006t\u0007b\u00028y\u0003\u0003\u0005\rA\u001b\u0005\n\u0003\u0003\u0001\u0013\u0011!C!\u0003\u0007\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002I\"I\u0011q\u0001\u0011\u0002\u0002\u0013\u0005\u0013\u0011B\u0001\ti>\u001cFO]5oOR\t!\fC\u0005\u0002\u000e\u0001\n\t\u0011\"\u0011\u0002\u0010\u00051Q-];bYN$2a_A\t\u0011!q\u00171BA\u0001\u0002\u0004Q\u0007cA\t\u0002\u0016%\u0019\u0011q\u0003\n\u0003\tUs\u0017\u000e\u001e\u0005\b\u00037iA\u0011AA\u000f\u0003\u00111Gn\\<\u0015\t\u0005}\u0011q\b\t\u000b\u0003C\ty#a\r\u00024\u0005MQBAA\u0012\u0015\u0011\t)#a\n\u0002\u0011M\u001c\u0017\r\\1eg2TA!!\u000b\u0002,\u000511\u000f\u001e:fC6T!!!\f\u0002\t\u0005\\7.Y\u0005\u0005\u0003c\t\u0019C\u0001\u0003GY><\b\u0003BA\u001b\u0003wi!!a\u000e\u000b\t\u0005e\u00121F\u0001\u0005kRLG.\u0003\u0003\u0002>\u0005]\"A\u0003\"zi\u0016\u001cFO]5oO\"A\u0011\u0011IA\r\u0001\u0004\t\u0019%\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016\u0004\"aH\r\u0007\r\u0005\u001dS\u0002BA%\u00059\u0019FO]3b[\u0012Kw-Z:uKJ\u001cB!!\u0012\u0002LAA\u0011QJA*\u0003g\t\u0019$\u0004\u0002\u0002P)!\u0011\u0011KA\u0014\u0003\u0015\u0019H/Y4f\u0013\u0011\t)&a\u0014\u0003\u0013A+8\u000f[*uC\u001e,\u0007bCA!\u0003\u000b\u0012\t\u0011)A\u0005\u0003\u0007BqaFA#\t\u0003\tY\u0006\u0006\u0003\u0002^\u0005}\u0003cA\u0010\u0002F!A\u0011\u0011IA-\u0001\u0004\t\u0019\u0005\u0003\u0006\u0002d\u0005\u0015#\u0019!C\u0005\u0003K\n\u0001\u0002Z5hKN$XM]\u000b\u0003\u0003O\u00022aHA5\r\u001d\tY'\u0004\u0001\u0003\u0003[\u0012\u0001\u0002R5hKN$XM]\n\u0004\u0003S\u0002\u0002bB\f\u0002j\u0011\u0005\u0011\u0011\u000f\u000b\u0003\u0003OB!\"!\u001e\u0002j\t\u0007I\u0011BA<\u0003\u001d\tG-\u00199uKJ,\"!!\u001f\u0011\t\u0005m\u0014qR\u0007\u0003\u0003{RA!a \u0002\u0002\u0006A\u0011\rZ1qi\u0016\u00148OC\u0002Q\u0003\u0007SA!!\"\u0002\b\u0006!!-\u001b8e\u0015\u0011\tI)a#\u0002\u0007alGN\u0003\u0002\u0002\u000e\u0006)!.\u0019<bq&!\u0011\u0011SA?\u0005AAU\r\u001f\"j]\u0006\u0014\u00180\u00113baR,'\u000fC\u0005\u0002\u0016\u0006%\u0004\u0015!\u0003\u0002z\u0005A\u0011\rZ1qi\u0016\u0014\b\u0005\u0003\u0006\u0002d\u0005%$\u0019!C\u0005\u00033+\"!a'\u0011\t\u0005u\u00151U\u0007\u0003\u0003?S1!!)_\u0003!\u0019XmY;sSRL\u0018\u0002BAS\u0003?\u0013Q\"T3tg\u0006<W\rR5hKN$\b\"CAU\u0003S\u0002\u000b\u0011BAN\u0003%!\u0017nZ3ti\u0016\u0014\b\u0005\u0003\u00057\u0003S\u0002\r\u0011\"\u00018\u0011)\ty+!\u001bA\u0002\u0013\u0005\u0011\u0011W\u0001\tg&TXm\u0018\u0013fcR!\u00111CAZ\u0011!q\u0017QVA\u0001\u0002\u0004A\u0004b\u0002\u001f\u0002j\u0001\u0006K\u0001\u000f\u0005\t\u0003s\u000bI\u0007\"\u0001\u0002<\u00061Q\u000f\u001d3bi\u0016$B!a\u0005\u0002>\"A\u0011qXA\\\u0001\u0004\t\t-A\u0003csR,7\u000fE\u0003\u0012\u0003\u0007\f9-C\u0002\u0002FJ\u0011Q!\u0011:sCf\u00042!EAe\u0013\r\tYM\u0005\u0002\u0005\u0005f$X\r\u0003\u0005\u0002P\u0006%D\u0011AAi\u0003\u0019!\u0017nZ3tiR\ta\u0004C\u0005\u0002*\u0006\u0015\u0003\u0015!\u0003\u0002h!A\u0011q[A#\t\u0003\nI.\u0001\u0004p]B+8\u000f\u001b\u000b\u0007\u00037\f\t/!:\u0011\t\u00055\u0013Q\\\u0005\u0005\u0003?\fyEA\u0007Ts:\u001cG)\u001b:fGRLg/\u001a\u0005\t\u0003G\f)\u000e1\u0001\u00024\u0005!Q\r\\3n\u0011!\t9/!6A\u0002\u0005%\u0018aA2uqB1\u0011QJAv\u0003gIA!!<\u0002P\t91i\u001c8uKb$\b\u0002CAy\u0003\u000b\"\t%a=\u0002!=tW\u000b]:ue\u0016\fWNR5oSNDG\u0003BA{\u0003w\u0004B!!\u0014\u0002x&!\u0011\u0011`A(\u0005Q!VM]7j]\u0006$\u0018n\u001c8ESJ,7\r^5wK\"A\u0011q]Ax\u0001\u0004\tIoB\u0005\u0002\u00006\t\t\u0011#\u0001\u0003\u0002\u00051A)[4fgR\u00042a\bB\u0002\r!\tS\"!A\t\u0002\t\u00151#\u0002B\u0002\u0005\u000f1\u0003c\u0002B\u0005\u0005\u001fa\u0003HH\u0007\u0003\u0005\u0017Q1A!\u0004\u0013\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0005\u0003\f\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f]\u0011\u0019\u0001\"\u0001\u0003\u0016Q\u0011!\u0011\u0001\u0005\u000b\u0003\u000f\u0011\u0019!!A\u0005F\u0005%\u0001B\u0003B\u000e\u0005\u0007\t\t\u0011\"!\u0003\u001e\u0005)\u0011\r\u001d9msR)aDa\b\u0003\"!1!F!\u0007A\u00021BaA\u000eB\r\u0001\u0004A\u0004B\u0003B\u0013\u0005\u0007\t\t\u0011\"!\u0003(\u00059QO\\1qa2LH\u0003\u0002B\u0015\u0005k\u0001R!\u0005B\u0016\u0005_I1A!\f\u0013\u0005\u0019y\u0005\u000f^5p]B)\u0011C!\r-q%\u0019!1\u0007\n\u0003\rQ+\b\u000f\\33\u0011%\u00119Da\t\u0002\u0002\u0003\u0007a$A\u0002yIAB!Ba\u000f\u0003\u0004\u0005\u0005I\u0011\u0002B\u001f\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t}\u0002cA.\u0003B%\u0019!1\t/\u0003\r=\u0013'.Z2u\u0001")
public final class DigesterStage {
    public static Flow<ByteString, ByteString, BoxedUnit> flow(Function1<Digest, BoxedUnit> function1) {
        return DigesterStage$.MODULE$.flow(function1);
    }

    public static class Digest
    implements Product,
    Serializable {
        private final String checksum;
        private final long size;

        public String checksum() {
            return this.checksum;
        }

        public long size() {
            return this.size;
        }

        public Digest copy(String checksum, long size) {
            return new Digest(checksum, size);
        }

        public String copy$default$1() {
            return this.checksum();
        }

        public long copy$default$2() {
            return this.size();
        }

        public String productPrefix() {
            return "Digest";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.size());
                    break;
                }
                case 0: {
                    object = this.checksum();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Digest;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.checksum()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Digest)) return false;
            boolean bl = true;
            if (!bl) return false;
            Digest digest = (Digest)x$1;
            String string = this.checksum();
            String string2 = digest.checksum();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.size() != digest.size()) return false;
            if (!digest.canEqual(this)) return false;
            return true;
        }

        public Digest(String checksum, long size) {
            this.checksum = checksum;
            this.size = size;
            Product.class.$init$((Product)this);
        }
    }

    public static class Digester {
        private final HexBinaryAdapter adapter = new HexBinaryAdapter();
        private final MessageDigest digester = MessageDigest.getInstance("SHA-1");
        private long size = 0L;

        private HexBinaryAdapter adapter() {
            return this.adapter;
        }

        private MessageDigest digester() {
            return this.digester;
        }

        public long size() {
            return this.size;
        }

        public void size_$eq(long x$1) {
            this.size = x$1;
        }

        public void update(byte[] bytes) {
            this.size_$eq(this.size() + (long)bytes.length);
            this.digester().update(bytes);
        }

        public Digest digest() {
            return new Digest(this.adapter().marshal(this.digester().digest()), this.size());
        }
    }

    public static class StreamDigester
    extends PushStage<ByteString, ByteString> {
        private final Function1<Digest, BoxedUnit> onComplete;
        private final Digester digester;

        private Digester digester() {
            return this.digester;
        }

        public SyncDirective onPush(ByteString elem, Context<ByteString> ctx) {
            this.digester().update((byte[])elem.toArray(ClassTag$.MODULE$.Byte()));
            return ctx.push((Object)elem);
        }

        public TerminationDirective onUpstreamFinish(Context<ByteString> ctx) {
            this.onComplete.apply((Object)this.digester().digest());
            return super.onUpstreamFinish(ctx);
        }

        public StreamDigester(Function1<Digest, BoxedUnit> onComplete) {
            this.onComplete = onComplete;
            this.digester = new Digester();
        }
    }
}

