package com.xebialabs.satellite.streaming

import java.io.InputStream

import akka.stream.io.InputStreamSource
import akka.stream.scaladsl.{FlattenStrategy, Source}
import akka.util.ByteString
import com.xebialabs.satellite.streaming.DigesterStage._
import grizzled.slf4j.Logging

import scala.concurrent.Future

object UploadStage extends Logging {

  def source(startOn: Future[Any], inputStream: InputStream)(digesterOnComplete: ProcessDigest)(implicit streamConfig: StreamConfig): Source[ByteString, _] = {

    Source() { implicit builder =>
      import akka.stream.scaladsl.FlowGraph.Implicits._
      val bytes = builder.add(Source(startOn).map(_ => InputStreamSource(() => inputStream, streamConfig.chunkSize)).flatten(FlattenStrategy.concat))

      val compress = builder.add(Compression.compress)

      bytes ~> DigesterStage.flow(digesterOnComplete) ~> compress

      compress.outlet
    }
  }
}
